/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.registery.items;

import com.mojang.datafixers.util.Pair;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.foundation.ChassisArmorMaterial;
import com.nukateam.chassis_core.common.foundation.item.ChassisItem;
import com.nukateam.nukacraft.common.data.enums.PowerArmorPart;
import com.nukateam.nukacraft.common.data.utils.PowerArmorStorage;
import com.nukateam.nukacraft.common.datagen.utils.annotations.ItemModelGen;
import com.nukateam.nukacraft.common.foundation.entities.misc.PowerArmorFrame;
import com.nukateam.nukacraft.common.foundation.items.frame.ArmorPart;
import com.nukateam.nukacraft.common.foundation.materials.PowerArmorMaterials;
import com.nukateam.nukacraft.common.registery.entities.ModEntities;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class PowerArmorItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nukacraft");
    @ItemModelGen
    public static final RegistryObject<Item> FRAME_ITEM = ITEMS.register("power_armor_frame", () -> new ChassisItem(new Item.Properties().m_41486_(), ModEntities.POWER_ARMOR_FRAME, PowerArmorFrame::new));
    @ItemModelGen(path="power_armor/t45")
    public static final PowerArmorStorage T45_SET = PowerArmorItems.registerArmorSet("t45", PowerArmorMaterials.T45);
    @ItemModelGen(path="power_armor/t51")
    public static final PowerArmorStorage T51_SET = PowerArmorItems.registerArmorSet("t51", PowerArmorMaterials.T51);
    @ItemModelGen(path="power_armor/t60")
    public static final PowerArmorStorage T60_SET = PowerArmorItems.registerArmorSet("t60", PowerArmorMaterials.T60);
    @ItemModelGen(path="power_armor/x01")
    public static final PowerArmorStorage X01_SET = PowerArmorItems.registerArmorSet("x01", PowerArmorMaterials.X01);
    @ItemModelGen(path="power_armor/x02")
    public static final PowerArmorStorage X02_SET = PowerArmorItems.registerArmorSet("x02", PowerArmorMaterials.X02);
    @ItemModelGen(path="power_armor/x02_cryo")
    public static final PowerArmorStorage X02_CRYO_SET = PowerArmorItems.registerArmorSet("x02_cryo", PowerArmorMaterials.X02_CRYO);
    @ItemModelGen(path="power_armor/raider")
    public static final PowerArmorStorage RAIDER_SET = PowerArmorItems.registerArmorSet("raider", PowerArmorMaterials.RAIDER);
    @ItemModelGen(path="power_armor/excavator")
    public static final PowerArmorStorage EXCAVATOR_SET = PowerArmorItems.registerArmorSet("excavator", PowerArmorMaterials.EXCAVATOR);

    private static RegistryObject<Item> registerArmor(String name, ChassisPart slot, ChassisArmorMaterial material) {
        return ITEMS.register(name, () -> new ArmorPart(material, slot));
    }

    private static PowerArmorStorage registerArmorSet(String name, ChassisArmorMaterial material) {
        PowerArmorStorage armorSet = new PowerArmorStorage();
        List<Pair> armorSlots = List.of(Pair.of((Object)((Object)PowerArmorPart.HELMET), (Object)ChassisPart.HELMET), Pair.of((Object)((Object)PowerArmorPart.BODY), (Object)ChassisPart.BODY_ARMOR), Pair.of((Object)((Object)PowerArmorPart.RIGHT_ARM), (Object)ChassisPart.RIGHT_ARM_ARMOR), Pair.of((Object)((Object)PowerArmorPart.LEFT_ARM), (Object)ChassisPart.LEFT_ARM_ARMOR), Pair.of((Object)((Object)PowerArmorPart.RIGHT_LEG), (Object)ChassisPart.RIGHT_LEG_ARMOR), Pair.of((Object)((Object)PowerArmorPart.LEFT_LEG), (Object)ChassisPart.LEFT_LEG_ARMOR));
        for (Pair slot : armorSlots) {
            RegistryObject<Item> item = PowerArmorItems.registerArmor(name + "_" + ((PowerArmorPart)((Object)slot.getFirst())).getName(), (ChassisPart)slot.getSecond(), material);
            armorSet.put((PowerArmorPart)((Object)slot.getFirst()), item);
        }
        return armorSet;
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

