/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.mixin.client;

import com.nukateam.ntgl.client.util.handler.GunRenderingHandler;
import com.nukateam.nukacraft.common.data.constants.Textures;
import com.nukateam.nukacraft.common.data.enums.HeartType;
import com.nukateam.nukacraft.common.registery.ModAttributes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Unique
    protected final RandomSource random = RandomSource.m_216327_();

    private static double getPlayerRadiation() {
        return Minecraft.m_91087_().f_91074_.m_21133_((Attribute)ModAttributes.RADIATION.get());
    }

    @Unique
    private static void renderRadHeart(GuiGraphics pGuiGraphics, int heartPosX, int heartPosY, boolean isFull) {
        pGuiGraphics.m_280163_(Textures.RAD_HEART_ICON, heartPosX, heartPosY, isFull ? 0.0f : 9.0f, 0.0f, 9, 9, 18, 9);
    }

    private void renderHeart(GuiGraphics pGuiGraphics, HeartType pHeartType, int pX, int pY, int pYOffset, boolean pRenderHighlight, boolean pHalfHeart) {
        pGuiGraphics.m_280218_(GunRenderingHandler.GUI_ICONS_LOCATION, pX, pY, pHeartType.getX(pHalfHeart, pRenderHighlight), pYOffset, 9, 9);
    }

    @Inject(method={"renderHearts"}, at={@At(value="HEAD")}, cancellable=true)
    protected void renderHearts(GuiGraphics graphics, Player player, int x, int y, int height, int regen, float healthMax, int health, int healthLast, int absorb, boolean highlight, CallbackInfo ci) {
        HeartType heartType = HeartType.forPlayer(player);
        int yOffset = 9 * (player.m_9236_().m_6106_().m_5466_() ? 5 : 0);
        int rads = (int)GuiMixin.getPlayerRadiation();
        int baseMaxHealth = (int)player.m_21172_(Attributes.f_22276_);
        int baseMaxHearts = Mth.m_14165_((double)((double)baseMaxHealth / 2.0));
        int radHearts = Mth.m_14107_((double)((double)rads / 2.0));
        int maxHearts = Mth.m_14165_((double)((double)healthMax / 2.0));
        int absorbHearts = Mth.m_14165_((double)((double)absorb / 2.0));
        int maxHalfHearts = maxHearts * 2;
        if (radHearts + maxHearts > baseMaxHearts) {
            radHearts = baseMaxHearts - maxHearts;
        }
        int allHearts = maxHearts + absorbHearts + radHearts;
        for (int heartId = allHearts - 1; heartId >= 0; --heartId) {
            boolean isHalf;
            boolean isLastHeartId;
            int rows = heartId / 10;
            int heartInRow = heartId % 10;
            int heartPosX = x + heartInRow * 8;
            int heartPosY = y - rows * height;
            if (health + absorb <= 4) {
                heartPosY += this.random.m_188503_(2);
            }
            if (heartId < maxHearts && heartId == regen) {
                heartPosY -= 2;
            }
            this.renderHeart(graphics, HeartType.CONTAINER, heartPosX, heartPosY, yOffset, highlight, false);
            int halfHearts = heartId * 2;
            boolean isHealthOdd = health != maxHearts * 2;
            boolean bl = isLastHeartId = heartId == maxHearts - 1;
            if (isHealthOdd && isLastHeartId && rads > 0) {
                GuiMixin.renderRadHeart(graphics, heartPosX, heartPosY, false);
            }
            if (heartId >= maxHearts) {
                if (allHearts - absorbHearts > heartId) {
                    GuiMixin.renderRadHeart(graphics, heartPosX, heartPosY, true);
                } else {
                    int additionalHearts = halfHearts - maxHalfHearts;
                    if (additionalHearts < absorb) {
                        boolean isHalf2 = additionalHearts + 1 == absorb;
                        this.renderHeart(graphics, heartType == HeartType.WITHERED ? heartType : HeartType.ABSORBING, heartPosX, heartPosY, yOffset, false, isHalf2);
                    }
                }
            }
            if (highlight && halfHearts < healthLast) {
                isHalf = halfHearts + 1 == healthLast;
                this.renderHeart(graphics, heartType, heartPosX, heartPosY, yOffset, true, isHalf);
            }
            if (halfHearts >= health) continue;
            isHalf = halfHearts + 1 == health;
            this.renderHeart(graphics, heartType, heartPosX, heartPosY, yOffset, false, isHalf);
        }
        ci.cancel();
    }
}

