/*
 * Decompiled with CFR 0.152.
 */
package cn.taskeren.minequery.config;

import cn.taskeren.minequery.MineQuery;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class CommandShortcutData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(class_310.method_1551().field_1697, "config/minequery-command-shortcut.json");
    private static Map<String, String> data;

    public static void load() {
        if (!CONFIG_FILE.getParentFile().exists()) {
            boolean bl = CONFIG_FILE.getParentFile().mkdirs();
        }
        if (!CONFIG_FILE.isFile()) {
            boolean ignored = CONFIG_FILE.renameTo(new File(CONFIG_FILE.getParentFile(), "minequery-command-shortcut.json.corrupted"));
            MineQuery.LOGGER.warn("The command shortcut data is corrupted, and it is moved to .corrupted file.");
        }
        if (!CONFIG_FILE.exists()) {
            data = new HashMap<String, String>();
            try (FileWriter fw = new FileWriter(CONFIG_FILE);){
                fw.write(GSON.toJson(data));
            }
            catch (IOException e) {
                MineQuery.LOGGER.warn("Unable to write command shortcut data! The changes are not saved.", (Throwable)e);
            }
            return;
        }
        try (FileReader fr = new FileReader(CONFIG_FILE);){
            data = (HashMap)GSON.fromJson((Reader)fr, HashMap.class);
        }
        catch (JsonIOException | IOException fnf) {
            MineQuery.LOGGER.warn("Unable to read command shortcut data! Unreachable!", fnf);
            throw new RuntimeException(fnf);
        }
        catch (JsonSyntaxException jse) {
            data = new HashMap<String, String>();
            MineQuery.LOGGER.warn("The json syntax is corrupted; all data is ignored.", (Throwable)jse);
        }
    }

    public static void save() {
        try (FileWriter fw = new FileWriter(CONFIG_FILE);){
            fw.write(GSON.toJson(data));
        }
        catch (IOException e) {
            MineQuery.LOGGER.warn("Unable to write command shortcut data! The changes are not saved.", (Throwable)e);
        }
    }

    @Nullable
    public static String getCommandText(int i) {
        if (data == null) {
            CommandShortcutData.load();
        }
        return data.getOrDefault("C-" + i, null);
    }

    public static String getCommandTextOrEmpty(int i) {
        String text = CommandShortcutData.getCommandText(i);
        return text == null ? "" : text;
    }

    public static void setCommandText(int i, @Nullable String s) {
        if (data == null) {
            CommandShortcutData.load();
        }
        if (s != null) {
            data.put("C-" + i, s);
        } else {
            data.remove("C-" + i);
        }
        CommandShortcutData.save();
    }
}

