/*
 * Decompiled with CFR 0.152.
 */
package cn.taskeren.minequery.features;

import cn.taskeren.minequery.config.MineQueryConfig;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.event.events.common.InteractionEvent;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class NotPlace {
    private static final String STICK_NAME = "NotPlace";
    private static final EnumMap<class_2350, Boolean> NOT_PLACE_MAP = new EnumMap(class_2350.class);

    public static void init() {
        InteractionEvent.RIGHT_CLICK_BLOCK.register(NotPlace::onRightClick);
        ClientTooltipEvent.ITEM.register(NotPlace::onItemTooltip);
    }

    private static boolean isMagicStick(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8600 && stack.method_7964().getString().equalsIgnoreCase(STICK_NAME);
    }

    private static boolean canPlaceAt(class_2350 direction) {
        return NOT_PLACE_MAP.get(direction) == false;
    }

    private static void flipNotPlaceState(class_2350 direction) {
        NOT_PLACE_MAP.put(direction, NotPlace.canPlaceAt(direction));
    }

    private static class_5250 getDirectionLocalizedName(class_2350 direction) {
        return class_2561.method_43471((String)("minequery.tooltip.not_place." + direction.name().toLowerCase(Locale.ROOT)));
    }

    private static class_2561 getDirectionStateColoredLocalizedText(class_2350 direction, boolean useText) {
        if (NotPlace.canPlaceAt(direction)) {
            return (useText ? class_2561.method_43471((String)"minequery.tooltip.not_place.allow.text") : class_2561.method_43471((String)"minequery.tooltip.not_place.allow")).method_27692(class_124.field_1060);
        }
        return (useText ? class_2561.method_43471((String)"minequery.tooltip.not_place.deny.text") : class_2561.method_43471((String)"minequery.tooltip.not_place.deny")).method_27692(class_124.field_1061);
    }

    private static class_1269 onRightClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (!MineQueryConfig.enableNotPlace) {
            return class_1269.field_5811;
        }
        class_1799 item = player.method_5998(hand);
        if (player.method_5715() && NotPlace.isMagicStick(item)) {
            NotPlace.flipNotPlaceState(direction);
            player.method_7353((class_2561)class_2561.method_43469((String)"minequery.tooltip.not_place.updated", (Object[])new Object[]{NotPlace.getDirectionLocalizedName(direction).method_27692(class_124.field_1054), NotPlace.getDirectionStateColoredLocalizedText(direction, true)}), false);
            return class_1269.field_5814;
        }
        if (item.method_7909() instanceof class_1747 && !NotPlace.canPlaceAt(direction)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static void onItemTooltip(class_1799 stack, List<class_2561> texts, class_1792.class_9635 context, class_1836 type) {
        if (NotPlace.isMagicStick(stack)) {
            long tickLong = class_310.method_1551().field_1687.method_28104().method_188();
            int tick = (int)(tickLong /= 5L);
            class_5250 title = class_2561.method_43471((String)"minequery.tooltip.not_place").method_27661().method_27692(class_124.values()[tick % class_124.values().length]);
            texts.add((class_2561)title);
            for (class_2350 direction : class_2350.values()) {
                class_5250 directionText = NotPlace.getDirectionLocalizedName(direction).method_27692(class_124.field_1080);
                class_2561 stateText = NotPlace.getDirectionStateColoredLocalizedText(direction, false);
                texts.add((class_2561)directionText.method_10852(class_2561.method_30163((String)": ")).method_10852(stateText));
            }
        }
    }

    static {
        for (class_2350 direction : class_2350.values()) {
            NOT_PLACE_MAP.put(direction, false);
        }
    }
}

