/*
 * Decompiled with CFR 0.152.
 */
package cn.taskeren.minequery.features;

import dev.architectury.event.events.client.ClientTickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;

public class TickTaskScheduler {
    private static int ticks;
    private static final Map<Integer, List<Runnable>> SCHEDULED_TASKS;

    public static void init() {
        ClientTickEvent.CLIENT_PRE.register(TickTaskScheduler::preTick);
    }

    private static List<Runnable> getOrCreateTasks(int ticks) {
        if (!SCHEDULED_TASKS.containsKey(ticks)) {
            SCHEDULED_TASKS.put(ticks, new ArrayList());
        }
        return SCHEDULED_TASKS.get(ticks);
    }

    public static void addTask(int afterTicks, Runnable task) {
        TickTaskScheduler.getOrCreateTasks(ticks + afterTicks).add(task);
    }

    private static void preTick(class_310 client) {
        List<Runnable> scheduledTasks;
        if ((scheduledTasks = SCHEDULED_TASKS.remove(++ticks)) != null) {
            scheduledTasks.forEach(Runnable::run);
        }
        if (ticks % 200 == 0) {
            Iterator<Map.Entry<Integer, List<Runnable>>> iter = SCHEDULED_TASKS.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Integer, List<Runnable>> entry = iter.next();
                Integer tick = entry.getKey();
                if (tick == null) continue;
                if (tick >= ticks) {
                    return;
                }
                iter.remove();
            }
        }
    }

    static {
        SCHEDULED_TASKS = new HashMap<Integer, List<Runnable>>();
    }
}

