/*
 * Decompiled with CFR 0.152.
 */
package cn.taskeren.minequery.screen;

import cn.taskeren.minequery.MineQuery;
import cn.taskeren.minequery.features.command_shortcut.CommandShortcut;
import cn.taskeren.minequery.features.command_shortcut.CommandShortcutHandle;
import cn.taskeren.minequery.utils.ScreenUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class CommandShortcutConfigScreen
extends class_437 {
    private static final int LIST_ITEM_HEIGHT = 25;
    private static final class_310 MINECRAFT_CLIENT = class_310.method_1551();
    private static final class_315 GAME_OPTIONS = CommandShortcutConfigScreen.MINECRAFT_CLIENT.field_1690;
    private final class_437 parent;
    private CommandShortcutListWidget list;
    @Nullable
    private class_304 selectedKeyBinding;

    public CommandShortcutConfigScreen(class_437 parent) {
        super(class_2561.method_30163((String)"123"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.list = (CommandShortcutListWidget)this.method_25429((class_364)new CommandShortcutListWidget(this.field_22787, this.field_22789, this.field_22790 - 57, 24, 25));
        for (int i = 0; i < CommandShortcut.SIZE; ++i) {
            this.list.addEntry(i);
        }
    }

    public void method_25419() {
        ScreenUtils.setScreen(this.parent);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.list.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.selectedKeyBinding != null) {
            if (keyCode == 256) {
                this.selectedKeyBinding.method_1422(class_3675.field_16237);
            } else {
                this.selectedKeyBinding.method_1422(class_3675.method_15985((int)keyCode, (int)scanCode));
            }
            this.selectedKeyBinding = null;
            this.list.update();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private class CommandShortcutListWidget
    extends class_4265<CommandShortcutEntry> {
        private final List<CommandShortcutEntry> entries;

        public CommandShortcutListWidget(class_310 minecraftClient, int width, int height, int y, int itemHeight) {
            super(minecraftClient, width, height, y, itemHeight);
            this.entries = new ArrayList<CommandShortcutEntry>();
        }

        protected int method_65507() {
            return this.field_22758 - 7;
        }

        public void addEntry(int index) {
            CommandShortcutEntry entry = new CommandShortcutEntry(index);
            this.entries.add(entry);
            this.method_25321((class_350.class_351)entry);
        }

        public void update() {
            class_304.method_1426();
            this.updateEntries();
        }

        public void updateEntries() {
            this.entries.forEach(CommandShortcutEntry::update);
        }

        public int method_25322() {
            return this.field_22758 / 2;
        }

        protected void method_44397(class_332 context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
            super.method_44397(context, mouseX, mouseY, delta, index, x, y, entryWidth, entryHeight);
        }

        private class CommandShortcutEntry
        extends class_4265.class_4266<CommandShortcutEntry> {
            private static final int LIST_ITEM_GAP = 4;
            private static final int LIST_BUTTON_WIDTH = 75;
            private final class_304 keyBinding;
            private final CommandShortcutHandle handle;
            private final class_342 textField;
            private final class_339 saveButton;
            private final class_339 keyButton;
            private String text;

            public CommandShortcutEntry(int index) {
                this(Objects.requireNonNull(CommandShortcut.get(index), "the required index " + index + " is null!"));
            }

            public CommandShortcutEntry(CommandShortcutHandle handle) {
                this.handle = handle;
                this.keyBinding = handle.getKeyBinding();
                this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"minequery.gui.command_shortcut.set"), this::onSaveButton).method_46432(75).method_46431();
                this.saveButton.field_22763 = false;
                this.keyButton = class_4185.method_46430((class_2561)this.keyBinding.method_16007(), this::onKeyBindingButton).method_46432(75).method_46431();
                this.textField = new class_342(CommandShortcutConfigScreen.this.field_22793, 0, 0, 150, 20, class_2561.method_30163((String)""));
                this.textField.method_1880(32500);
                this.textField.method_1863(this::onTextChange);
                this.text = handle.getCommandOrEmpty();
                this.textField.method_1852(this.text);
            }

            private void onTextChange(String s) {
                if (!this.saveButton.field_22763 && !this.text.contentEquals(s)) {
                    this.saveButton.field_22763 = true;
                }
            }

            private void onSaveButton(class_4185 buttonWidget) {
                this.text = this.textField.method_1882();
                this.handle.setCommand(this.text);
                MineQuery.LOGGER.info("Saving new command text {} to {}", (Object)this.text, (Object)this.handle.index());
                this.saveButton.field_22763 = false;
            }

            private void onKeyBindingButton(class_4185 buttonWidget) {
                CommandShortcutConfigScreen.this.selectedKeyBinding = this.keyBinding;
                CommandShortcutListWidget.this.update();
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                int consumableX = x;
                this.textField.method_46421(consumableX);
                this.textField.method_46419(y);
                this.textField.method_25358(entryWidth / 3 * 2);
                this.textField.method_25394(context, mouseX, mouseY, tickDelta);
                this.saveButton.method_46421(consumableX += entryWidth / 3 * 2 + 4);
                this.saveButton.method_46419(y);
                this.saveButton.method_25394(context, mouseX, mouseY, tickDelta);
                this.keyButton.method_46421(consumableX += 79);
                this.keyButton.method_46419(y);
                this.keyButton.method_25394(context, mouseX, mouseY, tickDelta);
            }

            void update() {
                this.keyButton.method_25355(this.keyBinding.method_16007());
                boolean duplicate = false;
                class_5250 duplicateInfo = class_2561.method_43473();
                if (!this.keyBinding.method_1415()) {
                    class_304[] allKeyBindings;
                    for (class_304 keyBinding : allKeyBindings = CommandShortcutConfigScreen.GAME_OPTIONS.field_1839) {
                        if (keyBinding == this.keyBinding || !this.keyBinding.method_1435(keyBinding)) continue;
                        if (duplicate) {
                            duplicateInfo.method_27693(", ");
                        }
                        duplicate = true;
                        duplicateInfo.method_10852((class_2561)class_2561.method_43471((String)keyBinding.method_1431()));
                    }
                }
                if (duplicate) {
                    this.keyButton.method_25355((class_2561)class_2561.method_43470((String)"[ ").method_10852((class_2561)this.keyButton.method_25369().method_27661().method_27692(class_124.field_1068)).method_27693(" ]").method_27692(class_124.field_1061));
                    this.keyButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{duplicateInfo})));
                } else {
                    this.keyButton.method_47400(null);
                }
                if (CommandShortcutConfigScreen.this.selectedKeyBinding == this.keyBinding) {
                    this.keyButton.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)this.keyButton.method_25369().method_27661().method_27695(new class_124[]{class_124.field_1068, class_124.field_1073})).method_27693(" <").method_27692(class_124.field_1054));
                }
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.textField, this.saveButton, this.keyButton);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.textField, this.saveButton, this.keyButton);
            }
        }
    }
}

