/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegisterEvent;

public class RNSSoundEvents {
    public static final List<RNSSoundEntry> ALL = new ArrayList<RNSSoundEntry>();
    public static RNSSoundEntry SCANNER_SCROLL = RNSSoundEvents.create("scanner_scroll").category(SoundSource.PLAYERS).build();
    public static RNSSoundEntry SCANNER_CLICK = RNSSoundEvents.create("scanner_click", 2).category(SoundSource.PLAYERS).build();
    public static RNSSoundEntry SCANNER_DISCOVERY_PING = RNSSoundEvents.create("scanner_discovery_ping", 2).category(SoundSource.PLAYERS).build();
    public static RNSSoundEntry SCANNER_DISCOVERY_SUCCESS = RNSSoundEvents.create("scanner_discovery_success").category(SoundSource.PLAYERS).build();
    public static RNSSoundEntry SCANNER_TRACKING_PING = RNSSoundEvents.create("scanner_tracking_ping").category(SoundSource.PLAYERS).build();
    public static RNSSoundEntry DEPOSIT_FOUND = RNSSoundEvents.create("deposit_found").category(SoundSource.PLAYERS).build();

    public static RNSSoundEntryBuilder create(String id) {
        return new RNSSoundEntryBuilder(id, 1);
    }

    public static RNSSoundEntryBuilder create(String id, int n_sounds) {
        return new RNSSoundEntryBuilder(id, n_sounds);
    }

    public static void register(RegisterEvent event) {
        event.register(Registries.f_256840_, helper -> {
            for (RNSSoundEntry e : ALL) {
                e.register((RegisterEvent.RegisterHelper<SoundEvent>)helper);
            }
        });
    }

    public static class RNSSoundEntryBuilder {
        private final ResourceLocation id;
        private final int n_sounds;
        private SoundSource category = SoundSource.MASTER;

        public RNSSoundEntryBuilder(String id, int n_sounds) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)id);
            this.n_sounds = n_sounds;
        }

        public RNSSoundEntryBuilder category(SoundSource category) {
            this.category = category;
            return this;
        }

        public RNSSoundEntry build() {
            RNSSoundEntry e = new RNSSoundEntry(this.id, this.category, this.n_sounds);
            ALL.add(e);
            return e;
        }
    }

    public static class RNSSoundEntry {
        public final ResourceLocation id;
        public final SoundSource category;
        public final int n_sounds;
        public List<SoundEvent> events = null;

        public RNSSoundEntry(ResourceLocation id, SoundSource category, int n_sounds) {
            this.id = id;
            this.category = category;
            this.n_sounds = n_sounds;
        }

        public void register(RegisterEvent.RegisterHelper<SoundEvent> helper) {
            this.events = new ArrayList<SoundEvent>(this.n_sounds);
            for (int i = 0; i < this.n_sounds; ++i) {
                ResourceLocation curId = this.getIdOf(i);
                SoundEvent event = SoundEvent.m_262824_((ResourceLocation)curId);
                this.events.add(event);
                helper.register(curId, (Object)event);
            }
        }

        public void playInHand(Level level, Vec3i pos, float volume, float pitch, boolean fade) {
            if (this.events == null) {
                return;
            }
            for (SoundEvent e : this.events) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, e, this.category, volume, pitch, fade);
            }
        }

        public void playInHand(Level level, Vec3i pos) {
            this.playInHand(level, pos, 1.0f, 1.0f, true);
        }

        private ResourceLocation getIdOf(int i) {
            return i == 0 ? this.id : ResourceLocation.fromNamespaceAndPath((String)this.id.m_135827_(), (String)(this.id.m_135815_() + "_compounded_" + i));
        }
    }
}

