/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.data.pack;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.data.pack.DynamicDatapackResources;
import com.bmaster.createrns.data.pack.json.DepositStructure;
import com.bmaster.createrns.data.pack.json.DepositStructureSet;
import com.bmaster.createrns.data.pack.json.DepositStructureStart;
import com.bmaster.createrns.data.pack.json.DepositStructureTag;
import com.bmaster.createrns.data.pack.json.HasDepositBiomeTag;
import com.bmaster.createrns.data.pack.json.ReplaceWithProcessor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DynamicDatapack {
    public static final Function<String, ResourceLocation> PROCESSOR_RL = name -> ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"deposit/%s".formatted(name));
    public static final Function<String, ResourceLocation> STRUCT_START_RL = name -> ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"deposit_%s/start".formatted(name));
    public static final Function<String, ResourceLocation> STRUCT_RL = name -> ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"deposit_%s".formatted(name));
    private static final String PROCESSOR_PATH = "%s/worldgen/processor_list/deposit/%s.json";
    private static final String STRUCT_START_PATH = "%s/worldgen/template_pool/deposit_%s/start.json";
    private static final String STRUCT_PATH = "%s/worldgen/structure/deposit_%s.json";
    private static final String STRUCT_SET_PATH = "%s/worldgen/structure_set/deposits.json";
    private static final String HAS_DEPOSIT_TAG_PATH = "%s/tags/worldgen/biome/has_deposit.json";
    private static final String DEPOSIT_STRUCTURE_TAG_PATH = "%s/tags/worldgen/structure/deposits.json";
    private static final String HAS_DEPOSIT_TAG = "#%s:has_deposit";
    private static final String NOOP_PROCESSOR = "minecraft:empty";
    private static final String PLACEHOLDER_BLOCK = "minecraft:end_stone";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final DynamicDatapackResources depositsResources = new DynamicDatapackResources("%s:dynamic_data".formatted("create_rns"));
    private static final Set<Tuple<ResourceLocation, Integer>> bulkNBTPool = Set.of(new Tuple((Object)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"ore_deposit_medium"), (Object)70), new Tuple((Object)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"ore_deposit_large"), (Object)30));
    private static final Set<Tuple<ResourceLocation, Integer>> preciousNBTPool = Set.of(new Tuple((Object)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"ore_deposit_small"), (Object)70), new Tuple((Object)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"ore_deposit_medium"), (Object)28), new Tuple((Object)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"ore_deposit_large"), (Object)2));
    private static final ObjectOpenHashSet<Deposit> deposits = new ObjectOpenHashSet();

    public static void addDepositBiomeTag() {
        String path = HAS_DEPOSIT_TAG_PATH.formatted("create_rns");
        depositsResources.putJson(path, gson.toJsonTree((Object)new HasDepositBiomeTag()));
    }

    public static void addVanillaDeposits() {
        deposits.add((Object)new Deposit("iron", (Block)RNSContent.IRON_DEPOSIT_BLOCK.get(), bulkNBTPool, 8, 10));
        deposits.add((Object)new Deposit("copper", (Block)RNSContent.COPPER_DEPOSIT_BLOCK.get(), bulkNBTPool, 8, 5));
        deposits.add((Object)new Deposit("zinc", (Block)RNSContent.ZINC_DEPOSIT_BLOCK.get(), preciousNBTPool, 8, 2));
        deposits.add((Object)new Deposit("gold", (Block)RNSContent.GOLD_DEPOSIT_BLOCK.get(), preciousNBTPool, 12, 2));
        deposits.add((Object)new Deposit("redstone", (Block)RNSContent.REDSTONE_DEPOSIT_BLOCK.get(), preciousNBTPool, 12, 2));
    }

    public static void addDepositSetAndTag() {
        String path = DEPOSIT_STRUCTURE_TAG_PATH.formatted("create_rns");
        DepositStructureTag tag = new DepositStructureTag(deposits.stream().map(d -> STRUCT_RL.apply(d.name).toString()).toList());
        depositsResources.putJson(path, gson.toJsonTree((Object)tag));
        new DepositSet((Set<Deposit>)deposits).addToResources();
    }

    public static Pack finish() {
        return Pack.m_245429_((String)depositsResources.m_5542_(), (Component)Component.m_237119_(), (boolean)true, name -> depositsResources, (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_);
    }

    public static class Deposit {
        public final String name;
        @Nullable
        public final Block replacePlaceholderWith;
        public final Collection<Tuple<ResourceLocation, Integer>> nbts_and_weights;
        public final int depth;
        public final int weight;
        private boolean added = false;

        public Deposit(String name, @Nullable Block replacePlaceholderWith, Collection<Tuple<ResourceLocation, Integer>> nbts_and_weights, int depth, int weight) {
            this.name = name;
            this.replacePlaceholderWith = replacePlaceholderWith;
            this.nbts_and_weights = nbts_and_weights;
            this.depth = depth;
            this.weight = weight;
        }

        private void addToResources() {
            String processor;
            if (this.added) {
                return;
            }
            if (this.depth < 0) {
                throw new IllegalArgumentException("Could not create deposit '%s': Depth cannot be negative".formatted(this.name));
            }
            if (this.weight < 0) {
                throw new IllegalArgumentException("Could not create deposit '%s': Weight cannot be negative".formatted(this.name));
            }
            if (this.replacePlaceholderWith != null) {
                ResourceLocation depBlockRL = ForgeRegistries.BLOCKS.getKey((Object)this.replacePlaceholderWith);
                if (depBlockRL == null) {
                    throw new IllegalArgumentException("Could not create a processor for deposit '%s': ".formatted(this.name) + "provided deposit block does not exist");
                }
                String procPath = DynamicDatapack.PROCESSOR_PATH.formatted("create_rns", this.name);
                depositsResources.putJson(procPath, gson.toJsonTree((Object)new ReplaceWithProcessor(DynamicDatapack.PLACEHOLDER_BLOCK, depBlockRL.toString())));
                processor = PROCESSOR_RL.apply(this.name).toString();
            } else {
                processor = DynamicDatapack.NOOP_PROCESSOR;
            }
            String sStartPath = DynamicDatapack.STRUCT_START_PATH.formatted("create_rns", this.name);
            List<DepositStructureStart.WeightedElement> elements = this.nbts_and_weights.stream().map(t -> new DepositStructureStart.WeightedElement(((ResourceLocation)t.m_14418_()).toString(), (Integer)t.m_14419_(), processor)).collect(Collectors.toList());
            depositsResources.putJson(sStartPath, gson.toJsonTree((Object)new DepositStructureStart(elements)));
            String sPath = DynamicDatapack.STRUCT_PATH.formatted("create_rns", this.name);
            ResourceLocation sStartRl = STRUCT_START_RL.apply(this.name);
            String tag = DynamicDatapack.HAS_DEPOSIT_TAG.formatted("create_rns");
            depositsResources.putJson(sPath, gson.toJsonTree((Object)new DepositStructure(sStartRl.toString(), -this.depth, tag)));
            this.added = true;
        }
    }

    public static class DepositSet {
        public Set<Deposit> deposits;
        private boolean added = false;

        public DepositSet(Set<Deposit> deposits) {
            this.deposits = deposits;
        }

        private void addToResources() {
            if (this.added) {
                return;
            }
            ArrayList<DepositStructureSet.WeightedStructure> wsList = new ArrayList<DepositStructureSet.WeightedStructure>();
            for (Deposit d : this.deposits) {
                d.addToResources();
                ResourceLocation sRL = STRUCT_RL.apply(d.name);
                wsList.add(new DepositStructureSet.WeightedStructure(sRL.toString(), d.weight));
            }
            String sSetPath = DynamicDatapack.STRUCT_SET_PATH.formatted("create_rns");
            depositsResources.putJson(sSetPath, gson.toJsonTree((Object)new DepositStructureSet(wsList)));
            this.added = true;
        }
    }
}

