/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.data.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.datafix.fixes.BlockEntitySignTextStrictJsonFix;
import org.jetbrains.annotations.NotNull;

public final class DynamicDatapackResources
implements PackResources {
    private final String packId;
    private final Map<ResourceLocation, byte[]> serverData = new Object2ObjectOpenHashMap();
    private final PackMetadataSection metadata;

    public DynamicDatapackResources(String packId) {
        this.packId = packId;
        int packFormat = SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA);
        this.metadata = new PackMetadataSection((Component)Component.m_237113_((String)packId), packFormat);
    }

    public void putJson(String path, JsonElement json) {
        this.serverData.put(DynamicDatapackResources.loc(path), BlockEntitySignTextStrictJsonFix.f_14861_.toJson(json).getBytes(StandardCharsets.UTF_8));
    }

    private static ResourceLocation loc(String path) {
        int idx = path.indexOf(47);
        String ns = path.substring(0, idx);
        String p = path.substring(idx + 1);
        return ResourceLocation.fromNamespaceAndPath((String)ns, (String)p);
    }

    @NotNull
    public String m_5542_() {
        return this.packId;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Set<String> m_5698_(PackType type) {
        if (type != PackType.SERVER_DATA) {
            return Set.of();
        }
        return this.serverData.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation rl) {
        if (type != PackType.SERVER_DATA) {
            return null;
        }
        byte[] b = this.serverData.get(rl);
        return b == null ? null : () -> new ByteArrayInputStream(b);
    }

    @ParametersAreNonnullByDefault
    public void m_8031_(PackType type, String ns, String path, PackResources.ResourceOutput out) {
        if (type != PackType.SERVER_DATA) {
            return;
        }
        Object pathWithSlash = path.endsWith("/") ? path : path + "/";
        for (Map.Entry<ResourceLocation, byte[]> e : this.serverData.entrySet()) {
            ResourceLocation rl = e.getKey();
            if (!rl.m_135827_().equals(ns) || !rl.m_135815_().startsWith((String)pathWithSlash)) continue;
            out.accept((Object)e.getKey(), () -> new ByteArrayInputStream((byte[])e.getValue()));
        }
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        if (elements.length == 1 && "pack.mcmeta".equals(elements[0])) {
            byte[] bytes = this.buildPackMcMetaBytes();
            return () -> new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer == PackMetadataSection.f_243696_) {
            PackMetadataSection t = this.metadata;
            return (T)t;
        }
        return null;
    }

    private byte[] buildPackMcMetaBytes() {
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.add("description", Component.Serializer.m_130716_((Component)this.metadata.m_10373_()));
        pack.addProperty("pack_format", (Number)this.metadata.getPackFormat(PackType.SERVER_DATA));
        root.add("pack", (JsonElement)pack);
        return BlockEntitySignTextStrictJsonFix.f_14861_.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8);
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }
}

