/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.deposit.capability;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.deposit.capability.IDepositIndex;
import com.bmaster.createrns.util.Utils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class DepositIndex
implements IDepositIndex,
INBTSerializable<CompoundTag> {
    public static final int MIN_COMPUTE_INTERVAL = 90;
    private final ObjectOpenHashSet<BlockPos> generatedFoundDeposits = new ObjectOpenHashSet();
    private final Object2ObjectOpenHashMap<ResourceLocation, ObjectOpenHashSet<BlockPos>> generatedDeposits = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceLocation, ObjectOpenHashSet<BlockPos>> ungeneratedDeposits = new Object2ObjectOpenHashMap();
    private final Cache<UUID, CachedData> perPlayerCache = CacheBuilder.newBuilder().initialCapacity(1).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    @Override
    @Nullable
    public BlockPos getNearest(ResourceKey<Structure> depositKey, ServerPlayer sp, int searchRadiusChunks) {
        double dist;
        Level sl = sp.m_9236_();
        CachedData hit = (CachedData)this.perPlayerCache.getIfPresent((Object)sp.m_20148_());
        if (hit != null && sl.m_46467_() - hit.creationTimestamp < 90L) {
            return null;
        }
        BlockPos playerPos = sp.m_20183_();
        BlockPos closestBP = null;
        double closestDist = Double.MAX_VALUE;
        for (BlockPos d : (ObjectOpenHashSet)this.generatedDeposits.getOrDefault((Object)depositKey.m_135782_(), (Object)new ObjectOpenHashSet())) {
            dist = playerPos.m_123331_((Vec3i)d);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestBP = new BlockPos((Vec3i)d);
        }
        for (BlockPos d : (ObjectOpenHashSet)this.ungeneratedDeposits.getOrDefault((Object)depositKey.m_135782_(), (Object)new ObjectOpenHashSet())) {
            dist = playerPos.m_123331_((Vec3i)d);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestBP = new BlockPos((Vec3i)d);
        }
        BlockPos closestUnknownBP = this.discoverNearest(depositKey, sp, searchRadiusChunks);
        if (closestUnknownBP != null && playerPos.m_123331_((Vec3i)closestUnknownBP) < closestDist) {
            closestBP = closestUnknownBP;
        }
        if (closestBP == null) {
            this.perPlayerCache.put((Object)sp.m_20148_(), (Object)new CachedData(null, depositKey, sl.m_46467_()));
            CreateRNS.LOGGER.debug("No deposits of target type are recorded");
            return null;
        }
        if (this.isOutsideSearchRadius(playerPos, closestBP, searchRadiusChunks)) {
            this.perPlayerCache.put((Object)sp.m_20148_(), (Object)new CachedData(closestBP.m_121878_(), depositKey, sl.m_46467_()));
            CreateRNS.LOGGER.debug("No deposits in scanned area. Closest is at {},{} ({} blocks away)", new Object[]{closestBP.m_123341_(), closestBP.m_123343_(), (int)Math.sqrt(closestDist)});
            return null;
        }
        this.perPlayerCache.put((Object)sp.m_20148_(), (Object)new CachedData(closestBP.m_121878_(), depositKey, sl.m_46467_()));
        CreateRNS.LOGGER.debug("Found deposit at {},{}", (Object)closestBP.m_123341_(), (Object)closestBP.m_123343_());
        return closestBP;
    }

    @Override
    @Nullable
    public BlockPos getNearestCached(ResourceKey<Structure> depositKey, ServerPlayer sp, int searchRadiusChunks) {
        CachedData hit = (CachedData)this.perPlayerCache.getIfPresent((Object)sp.m_20148_());
        if (hit == null) {
            CreateRNS.LOGGER.trace("[Cache miss] Deposit position is not cached for player");
            return null;
        }
        if (hit.dPosPacked == null) {
            CreateRNS.LOGGER.trace("[Cache hit] Deposit position in cache is null");
            return null;
        }
        BlockPos cachedBP = BlockPos.m_122022_((long)hit.dPosPacked);
        if (!hit.depositKey.equals(depositKey)) {
            CreateRNS.LOGGER.trace("[Cache hit] Found deposit at {},{}, but its type does not match the requested type", (Object)cachedBP.m_123341_(), (Object)cachedBP.m_123343_());
        }
        if (this.isOutsideSearchRadius(sp.m_20183_(), cachedBP, searchRadiusChunks)) {
            CreateRNS.LOGGER.trace("[Cache hit] Found deposit at {},{}, but it's too far away", (Object)cachedBP.m_123341_(), (Object)cachedBP.m_123343_());
            return null;
        }
        CreateRNS.LOGGER.trace("[Cache hit] Found deposit at {},{}", (Object)cachedBP.m_123341_(), (Object)cachedBP.m_123343_());
        return cachedBP;
    }

    @Override
    public void add(ResourceKey<Structure> depositKey, StructureStart ss, ServerLevel sl) {
        ChunkPos startChunk = ss.m_163625_();
        if (!ss.m_73603_()) {
            CreateRNS.LOGGER.error("Attempted to add an invalid deposit start to deposit index");
            return;
        }
        BlockPos center = ss.m_73601_().m_162394_();
        for (Object2ObjectMap.Entry t : this.ungeneratedDeposits.object2ObjectEntrySet()) {
            ObjectOpenHashSet dSet = (ObjectOpenHashSet)t.getValue();
            boolean removed = dSet.removeIf(d -> Utils.isPosInChunk(d, startChunk));
            if (!removed) continue;
            this.perPlayerCache.asMap().replaceAll((u, d) -> {
                if (d == null) {
                    return null;
                }
                if (d.dPosPacked == null || !Utils.isPosInChunk(BlockPos.m_122022_((long)d.dPosPacked), startChunk)) {
                    return d;
                }
                return new CachedData(center.m_121878_(), d.depositKey, d.creationTimestamp);
            });
            CreateRNS.LOGGER.debug("Generated deposit start at {},{} removed from ungenerated", (Object)startChunk.m_151382_(8), (Object)startChunk.m_151391_(8));
        }
        if (this.generatedFoundDeposits.contains((Object)center)) {
            return;
        }
        ((ObjectOpenHashSet)this.generatedDeposits.computeIfAbsent((Object)depositKey.m_135782_(), k -> new ObjectOpenHashSet())).add((Object)center);
    }

    @Override
    public void markAsFound(BlockPos centerPos) {
        Set foundGenSet = null;
        for (Object2ObjectMap.Entry e2 : this.generatedDeposits.object2ObjectEntrySet()) {
            ObjectOpenHashSet genSet = (ObjectOpenHashSet)e2.getValue();
            if (!genSet.contains((Object)centerPos)) continue;
            foundGenSet = genSet;
        }
        if (foundGenSet == null) {
            CreateRNS.LOGGER.error("Attempted to mark a non-existent deposit");
            return;
        }
        this.perPlayerCache.asMap().entrySet().removeIf(e -> {
            CachedData d = (CachedData)e.getValue();
            return d != null && d.dPosPacked != null && d.dPosPacked.longValue() == centerPos.m_121878_();
        });
        foundGenSet.remove(centerPos);
        this.generatedFoundDeposits.add((Object)centerPos);
        CreateRNS.LOGGER.debug("Marking {},{},{} as found", new Object[]{centerPos.m_123341_(), centerPos.m_123342_(), centerPos.m_123343_()});
    }

    public CompoundTag serializeNBT() {
        long[] packed;
        ResourceLocation rl;
        CompoundTag root = new CompoundTag();
        CompoundTag generated = new CompoundTag();
        CompoundTag ungenerated = new CompoundTag();
        CreateRNS.LOGGER.trace("Serializing GeneratedFound {}", this.generatedFoundDeposits);
        CreateRNS.LOGGER.trace("Serializing Generated {}", this.generatedDeposits);
        CreateRNS.LOGGER.trace("Serializing Ungenerated {}", this.ungeneratedDeposits);
        long[] generatedFound = this.generatedFoundDeposits.stream().mapToLong(BlockPos::m_121878_).toArray();
        for (Object2ObjectMap.Entry e : this.generatedDeposits.object2ObjectEntrySet()) {
            rl = (ResourceLocation)e.getKey();
            packed = ((ObjectOpenHashSet)e.getValue()).stream().mapToLong(BlockPos::m_121878_).toArray();
            generated.m_128388_(rl.toString(), packed);
        }
        for (Object2ObjectMap.Entry e : this.ungeneratedDeposits.object2ObjectEntrySet()) {
            rl = (ResourceLocation)e.getKey();
            packed = ((ObjectOpenHashSet)e.getValue()).stream().mapToLong(BlockPos::m_121878_).toArray();
            ungenerated.m_128388_(rl.toString(), packed);
        }
        root.m_128388_("GeneratedFound", generatedFound);
        root.m_128365_("Generated", (Tag)generated);
        root.m_128365_("Ungenerated", (Tag)ungenerated);
        CreateRNS.LOGGER.trace("Serialized deposit index with {}", (Object)root);
        return root;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ObjectOpenHashSet set;
        CompoundTag generated;
        LongArrayTag generatedFound;
        Object object;
        block8: {
            block7: {
                object = nbt.m_128423_("GeneratedFound");
                if (!(object instanceof LongArrayTag)) break block7;
                generatedFound = (LongArrayTag)object;
                object = nbt.m_128423_("Generated");
                if (!(object instanceof CompoundTag)) break block7;
                generated = (CompoundTag)object;
                object = nbt.m_128423_("Ungenerated");
                if (object instanceof CompoundTag) break block8;
            }
            CreateRNS.LOGGER.error("Failed to deserialize deposit index from nbt");
            return;
        }
        CompoundTag ungenerated = (CompoundTag)object;
        CreateRNS.LOGGER.trace("Deserializing deposit index with tag {}", (Object)nbt);
        this.generatedFoundDeposits.clear();
        this.generatedDeposits.clear();
        this.ungeneratedDeposits.clear();
        for (Tag l : (Object)generatedFound.m_128851_()) {
            this.generatedFoundDeposits.add((Object)BlockPos.m_122022_((long)l));
        }
        for (String key : generated.m_128431_()) {
            ResourceLocation rl = ResourceLocation.parse((String)key);
            long[] packed = generated.m_128467_(key);
            set = new ObjectOpenHashSet(packed.length);
            for (long l : packed) {
                set.add((Object)BlockPos.m_122022_((long)l));
            }
            this.generatedDeposits.put((Object)rl, (Object)set);
        }
        for (String key : ungenerated.m_128431_()) {
            ResourceLocation rl = ResourceLocation.parse((String)key);
            long[] packed = ungenerated.m_128467_(key);
            set = new ObjectOpenHashSet(packed.length);
            for (long l : packed) {
                set.add((Object)BlockPos.m_122022_((long)l));
            }
            this.ungeneratedDeposits.put((Object)rl, (Object)set);
        }
        CreateRNS.LOGGER.trace("Deserialized GeneratedFound to {}", this.generatedFoundDeposits);
        CreateRNS.LOGGER.trace("Deserialized Generated to {}", this.generatedDeposits);
        CreateRNS.LOGGER.trace("Deserialized Ungenerated to {}", this.ungeneratedDeposits);
    }

    @Nullable
    private BlockPos discoverNearest(ResourceKey<Structure> depositKey, ServerPlayer sp, int searchRadiusChunks) {
        StructureStart ss;
        ServerLevel sl = (ServerLevel)sp.m_9236_();
        ChunkGenerator gen = sl.m_7726_().m_8481_();
        Holder.Reference target = sl.m_9598_().m_175515_(Registries.f_256944_).m_246971_(depositKey);
        int searchRadiusRegions = searchRadiusChunks / 48;
        Pair newDeposit = gen.m_223037_(sl, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{target}), sp.m_20183_(), searchRadiusRegions, true);
        StructureStart structureStart = ss = newDeposit == null ? null : sl.m_215010_().m_220524_((BlockPos)newDeposit.getFirst(), (Structure)((Holder)newDeposit.getSecond()).get());
        if (newDeposit != null && !ss.m_73603_()) {
            BlockPos pos = (BlockPos)newDeposit.getFirst();
            CreateRNS.LOGGER.trace("Found undiscovered deposit at {}, {}, {}", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
            ((ObjectOpenHashSet)this.ungeneratedDeposits.computeIfAbsent((Object)depositKey.m_135782_(), k -> new ObjectOpenHashSet())).add((Object)pos);
            return pos;
        }
        if (newDeposit != null) {
            BlockPos pos = ss.m_73601_().m_162394_();
            CreateRNS.LOGGER.trace("Found undiscovered generated deposit at {}, {}, {}", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
            ((ObjectOpenHashSet)this.generatedDeposits.computeIfAbsent((Object)depositKey.m_135782_(), k -> new ObjectOpenHashSet())).add((Object)pos);
            return pos;
        }
        return null;
    }

    private boolean isOutsideSearchRadius(BlockPos playerPos, BlockPos dPos, int searchRadiusChunks) {
        int distZ;
        int distX = Math.abs(playerPos.m_123341_() - dPos.m_123341_());
        return Math.max(distX, distZ = Math.abs(playerPos.m_123343_() - dPos.m_123343_())) > searchRadiusChunks << 4;
    }

    private record CachedData(@Nullable Long dPosPacked, ResourceKey<Structure> depositKey, long creationTimestamp) {
    }
}

