/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.deposit.spec;

import com.bmaster.createrns.deposit.spec.DepositSpec;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.openmbean.KeyAlreadyExistsException;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class DepositSpecLookup {
    private static Map<Item, DepositSpec> scannerIconToSpec;
    private static List<Item> allIcons;
    private static Set<ResourceKey<Structure>> allStructureKeys;

    public static ResourceKey<Structure> getStructureKey(RegistryAccess access, Item scannerIconItem) {
        if (scannerIconToSpec == null) {
            DepositSpecLookup.build(access);
        }
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)scannerIconToSpec.get(scannerIconItem).structure());
    }

    public static void build(RegistryAccess access) {
        Set regEntries = access.m_175515_(DepositSpec.REGISTRY_KEY).m_6579_();
        scannerIconToSpec = new HashMap<Item, DepositSpec>(regEntries.size());
        regEntries.forEach(e -> {
            DepositSpec spec = (DepositSpec)e.getValue();
            Item scannerIcon = spec.scannerIconItem();
            if (ForgeRegistries.ITEMS.getKey((Object)scannerIcon) != null) {
                if (scannerIconToSpec.containsKey(scannerIcon)) {
                    throw new KeyAlreadyExistsException("Found multiple deposit specs with the same scanner icon");
                }
                scannerIconToSpec.put(scannerIcon, spec);
            }
        });
        allIcons = scannerIconToSpec.keySet().stream().sorted(Comparator.comparing(i -> {
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey(i);
            if (rl == null) {
                throw new IllegalStateException("This never happens, but my IDE won't shut up about it");
            }
            return rl;
        })).toList();
        allStructureKeys = scannerIconToSpec.values().stream().map(hs -> ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)hs.structure())).collect(Collectors.toUnmodifiableSet());
    }

    public static List<Item> getAllScannerIcons(RegistryAccess access) {
        if (allIcons == null) {
            DepositSpecLookup.build(access);
        }
        return allIcons;
    }

    public static Predicate<Structure> isDeposit(RegistryAccess access) {
        if (allStructureKeys == null) {
            DepositSpecLookup.build(access);
        }
        Registry reg = access.m_175515_(Registries.f_256944_);
        return checkedStructure -> reg.m_7854_(checkedStructure).filter(allStructureKeys::contains).isPresent();
    }
}

