/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.event;

import com.bmaster.createrns.deposit.capability.DepositIndexProvider;
import com.bmaster.createrns.deposit.capability.IDepositIndex;
import com.bmaster.createrns.deposit.spec.DepositSpecLookup;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="create_rns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerForgeEvents {
    @SubscribeEvent
    public static void onAttachCaps(AttachCapabilitiesEvent<Level> event) {
        Object object = event.getObject();
        if (!(object instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)object;
        event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"deposit_index"), (ICapabilityProvider)new DepositIndexProvider());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)levelAccessor;
        Optional depIdxOpt = IDepositIndex.fromLevel(sl).resolve();
        if (depIdxOpt.isEmpty()) {
            return;
        }
        IDepositIndex depIdx = (IDepositIndex)depIdxOpt.get();
        ChunkPos pos = e.getChunk().m_7697_();
        StructureManager sm = sl.m_215010_();
        for (StructureStart start : sm.m_220477_(pos, DepositSpecLookup.isDeposit(sl.m_9598_()))) {
            sl.m_9598_().m_175515_(Registries.f_256944_).m_7854_((Object)start.m_226861_()).ifPresent(structKey -> depIdx.add((ResourceKey<Structure>)structKey, start, sl));
        }
    }
}

