/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.infrastructure;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="create_rns", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<Float> MINER_MK1_SPEED_CV = BUILDER.comment(" How many mining operations a miner mk1 can complete in one hour\n at 256 RPM, with one deposit block claimed, and no deposit multipliers").define("minerSpeed", (Object)Float.valueOf(45.0f));
    private static final ForgeConfigSpec.ConfigValue<Float> MINER_MK2_SPEED_CV = BUILDER.comment(" How many mining operations a miner mk2 can complete in one hour\n at 256 RPM, with one deposit block claimed, and no deposit multipliers").define("minerSpeed", (Object)Float.valueOf(45.0f));
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static int minerMk1BaseProgress;
    public static int minerMk2BaseProgress;

    @SubscribeEvent
    static void onLoadReload(ModConfigEvent event) {
        if (event instanceof ModConfigEvent.Unloading) {
            return;
        }
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        int ticksPerHour = 72000;
        minerMk1BaseProgress = 256 * ticksPerHour / (int)((Float)MINER_MK1_SPEED_CV.get()).floatValue();
        minerMk2BaseProgress = 256 * ticksPerHour / (int)((Float)MINER_MK2_SPEED_CV.get()).floatValue();
    }
}

