/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.item.DepositScanner.DepositScannerChannel;
import com.bmaster.createrns.item.DepositScanner.DepositScannerServerHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record DepositScannerC2SPacket(Item item, DepositScannerServerHandler.RequestType rt) {
    public static void send(Item itemToScan, DepositScannerServerHandler.RequestType rt) {
        DepositScannerChannel.CHANNEL.sendToServer((Object)new DepositScannerC2SPacket(itemToScan, rt));
    }

    public static void encode(DepositScannerC2SPacket p, FriendlyByteBuf buf) {
        ResourceLocation pId = ForgeRegistries.ITEMS.getKey((Object)p.item);
        if (pId == null) {
            pId = ForgeRegistries.ITEMS.getKey((Object)Items.f_41852_);
        }
        if (pId != null) {
            buf.m_130085_(pId);
        }
        buf.m_130068_((Enum)p.rt);
    }

    public static DepositScannerC2SPacket decode(FriendlyByteBuf buf) {
        Item pItem = (Item)ForgeRegistries.ITEMS.getValue(buf.m_130281_());
        if (pItem == null) {
            pItem = Items.f_41852_;
        }
        return new DepositScannerC2SPacket(pItem, (DepositScannerServerHandler.RequestType)buf.m_130066_(DepositScannerServerHandler.RequestType.class));
    }

    public static void handle(DepositScannerC2SPacket p, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sp = ctx.getSender();
            if (sp == null) {
                return;
            }
            DepositScannerServerHandler.processScanRequest(sp, p.item, p.rt);
        });
        ctx.setPacketHandled(true);
    }
}

