/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.RNSSoundEvents;
import com.bmaster.createrns.deposit.spec.DepositSpecLookup;
import com.bmaster.createrns.item.DepositScanner.DepositScannerC2SPacket;
import com.bmaster.createrns.item.DepositScanner.DepositScannerItemRenderer;
import com.bmaster.createrns.item.DepositScanner.DepositScannerServerHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DepositScannerClientHandler {
    private static State state = new State();

    public static AntennaStatus getAntennaStatus() {
        return DepositScannerClientHandler.state.antennaStatus;
    }

    public static boolean isTracking() {
        return DepositScannerClientHandler.state.isTracking;
    }

    public static boolean isDepositFound() {
        return DepositScannerClientHandler.state.depositFound;
    }

    public static void cancelTracking(boolean playSound) {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return;
        }
        DepositScannerClientHandler.state.depositFound = false;
        DepositScannerClientHandler.state.isTracking = false;
        if (playSound) {
            RNSSoundEvents.SCANNER_CLICK.playInHand(p.m_9236_(), (Vec3i)p.m_20183_());
        }
    }

    public static void discoverDeposit() {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return;
        }
        DepositScannerC2SPacket.send(DepositScannerClientHandler.getSelectedItem().m_41720_(), DepositScannerServerHandler.RequestType.DISCOVER);
        RNSSoundEvents.SCANNER_CLICK.playInHand(p.m_9236_(), (Vec3i)p.m_20183_());
        RNSSoundEvents.SCANNER_DISCOVERY_PING.playInHand(p.m_9236_(), (Vec3i)p.m_20183_());
        DepositScannerItemRenderer.shakeItem();
    }

    public static void scrollDown() {
        ++DepositScannerClientHandler.state.selectedIndex;
        DepositScannerItemRenderer.scrollDown();
        DepositScannerClientHandler.afterScroll();
    }

    public static void scrollUp() {
        --DepositScannerClientHandler.state.selectedIndex;
        DepositScannerItemRenderer.scrollUp();
        DepositScannerClientHandler.afterScroll();
    }

    public static void clearState() {
        state = new State();
    }

    public static void tick() {
        if (DepositScannerClientHandler.state.trackingStateUpdatePending) {
            DepositScannerClientHandler.processTrackingStateUpdate();
        }
        DepositScannerItemRenderer.tick();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        LocalPlayer p = mc.f_91074_;
        if (p == null || p.m_5833_()) {
            return;
        }
        ItemStack heldItem = p.m_21205_();
        if (!RNSContent.DEPOSIT_SCANNER_ITEM.isIn(heldItem) && !RNSContent.DEPOSIT_SCANNER_ITEM.isIn(heldItem = p.m_21206_())) {
            DepositScannerItemRenderer.resetWheel();
            return;
        }
        if (DepositScannerClientHandler.state.depositFound || !DepositScannerClientHandler.state.isTracking) {
            return;
        }
        ++DepositScannerClientHandler.state.ticksSinceLastPing;
        if (DepositScannerClientHandler.state.ticksSinceLastPing >= DepositScannerClientHandler.state.pingInterval) {
            DepositScannerClientHandler.state.ticksSinceLastPing = 0;
            DepositScannerC2SPacket.send(DepositScannerClientHandler.getSelectedItem().m_41720_(), DepositScannerServerHandler.RequestType.TRACK);
        }
    }

    public static ItemStack getSelectedItem() {
        ClientLevel l = Minecraft.m_91087_().f_91073_;
        if (l == null) {
            return ItemStack.f_41583_;
        }
        List<Item> allItems = DepositSpecLookup.getAllScannerIcons(l.m_9598_());
        int size = allItems.size();
        int normalizedIndex = (DepositScannerClientHandler.state.selectedIndex % size + size) % size;
        return new ItemStack((ItemLike)allItems.get(normalizedIndex));
    }

    protected static void processDiscoverReply(AntennaStatus status) {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return;
        }
        DepositScannerClientHandler.state.isTracking = status != AntennaStatus.INACTIVE;
        DepositScannerClientHandler.state.ticksSinceLastPing = 0;
        DepositScannerClientHandler.state.pingInterval = 60;
        DepositScannerClientHandler.state.trackingStateUpdatePending = false;
        if (DepositScannerClientHandler.state.isTracking) {
            RNSSoundEvents.SCANNER_DISCOVERY_SUCCESS.playInHand(p.m_9236_(), (Vec3i)p.m_20183_());
        }
    }

    protected static void processTrackingReply(AntennaStatus status, int interval, boolean found) {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null || !p.m_9236_().m_5776_() || !DepositScannerClientHandler.state.isTracking) {
            return;
        }
        if (status == AntennaStatus.INACTIVE) {
            DepositScannerClientHandler.cancelTracking(false);
            return;
        }
        DepositScannerClientHandler.state.antennaStatus = status;
        DepositScannerClientHandler.state.pingInterval = interval;
        DepositScannerClientHandler.state.trackingStateUpdatePending = true;
        if (found) {
            DepositScannerClientHandler.state.antennaStatus = AntennaStatus.BOTH_ACTIVE;
            DepositScannerClientHandler.state.depositFound = true;
        }
    }

    private static void processTrackingStateUpdate() {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null || !p.m_9236_().m_5776_()) {
            return;
        }
        DepositScannerClientHandler.state.trackingStateUpdatePending = false;
        if (DepositScannerClientHandler.state.depositFound) {
            RNSSoundEvents.DEPOSIT_FOUND.playInHand(p.m_9236_(), (Vec3i)p.m_20183_());
            DepositScannerItemRenderer.shakeItem();
            return;
        }
        DepositScannerItemRenderer.powerBriefly();
        int max = 57;
        float pitchMultiplier = 1.0f - (float)(DepositScannerClientHandler.state.pingInterval - 3) / (float)max;
        RNSSoundEvents.SCANNER_TRACKING_PING.playInHand(p.m_9236_(), (Vec3i)p.m_20183_(), 1.0f, 0.8f + 0.4f * pitchMultiplier, true);
    }

    private static void afterScroll() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        DepositScannerClientHandler.cancelTracking(false);
        RNSSoundEvents.SCANNER_SCROLL.playInHand(player.m_9236_(), (Vec3i)player.m_20183_());
        ResourceLocation dRL = DepositSpecLookup.getStructureKey(player.m_9236_().m_9598_(), DepositScannerClientHandler.getSelectedItem().m_41720_()).m_135782_();
        MutableComponent dName = Component.m_237115_((String)(dRL.m_135827_() + ".structure." + dRL.m_135815_()));
        player.m_5661_((Component)dName, true);
    }

    private static class State {
        private AntennaStatus antennaStatus = AntennaStatus.INACTIVE;
        private int pingInterval = 60;
        private int selectedIndex = 0;
        private int ticksSinceLastPing = this.pingInterval;
        private boolean trackingStateUpdatePending = false;
        private boolean isTracking = false;
        private boolean depositFound = false;

        private State() {
        }
    }

    public static enum AntennaStatus {
        INACTIVE,
        LEFT_ACTIVE,
        RIGHT_ACTIVE,
        BOTH_ACTIVE;

    }
}

