/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.deposit.capability.IDepositIndex;
import com.bmaster.createrns.deposit.spec.DepositSpecLookup;
import com.bmaster.createrns.item.DepositScanner.DepositScannerClientHandler;
import com.bmaster.createrns.item.DepositScanner.DepositScannerS2CPacket;
import com.bmaster.createrns.util.Utils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;

public class DepositScannerServerHandler {
    public static final int MIN_PING_INTERVAL = 3;
    public static final int MAX_PING_INTERVAL = 60;
    public static final float FOUND_DISTANCE = 5.0f;
    private static final int SEARCH_RADIUS_CHUNKS = 192;
    private static final int MAX_BLOCK_DISTANCE = 3072;

    public static void processScanRequest(ServerPlayer sp, Item icon, RequestType rt) {
        Level level = sp.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        Optional depIdxOpt = IDepositIndex.fromLevel(sl).resolve();
        if (depIdxOpt.isEmpty()) {
            CreateRNS.LOGGER.error("Deposit index is not present on level {}", (Object)sl.m_46472_());
            DepositScannerS2CPacket.send(sp, DepositScannerClientHandler.AntennaStatus.INACTIVE, 0, false, rt);
            return;
        }
        IDepositIndex depIdx = (IDepositIndex)depIdxOpt.get();
        ResourceKey<Structure> structKey = DepositSpecLookup.getStructureKey(sl.m_9598_(), icon);
        BlockPos nearest = switch (rt) {
            default -> throw new IncompatibleClassChangeError();
            case RequestType.DISCOVER -> depIdx.getNearest(structKey, sp, 192);
            case RequestType.TRACK -> depIdx.getNearestCached(structKey, sp, 192);
        };
        ScannerState state = nearest == null ? new ScannerState(DepositScannerClientHandler.AntennaStatus.INACTIVE, 60, false) : DepositScannerServerHandler.getScannerState(sp, nearest);
        if (state.found) {
            depIdx.markAsFound(nearest);
        }
        DepositScannerS2CPacket.send(sp, state.antennaStatus, state.interval, state.found, rt);
    }

    private static ScannerState getScannerState(ServerPlayer sp, BlockPos targetPos) {
        BlockPos playerPos = sp.m_20183_();
        double distance = Math.min(3072.0, Math.sqrt(playerPos.m_123331_((Vec3i)targetPos)));
        float curYaw = sp.m_146908_();
        float targetYaw = DepositScannerServerHandler.getYaw(playerPos, targetPos);
        float diff = Mth.m_14177_((float)(targetYaw - curYaw));
        DepositScannerClientHandler.AntennaStatus status = Math.abs(diff) < 30.0f ? DepositScannerClientHandler.AntennaStatus.BOTH_ACTIVE : (diff <= 0.0f ? DepositScannerClientHandler.AntennaStatus.LEFT_ACTIVE : DepositScannerClientHandler.AntennaStatus.RIGHT_ACTIVE);
        int interval = 3 + (int)(57.0f * Utils.easeOut((float)distance / 3072.0f, 2.0f));
        boolean found = distance <= 5.0;
        return new ScannerState(status, interval, found);
    }

    private static float getYaw(BlockPos from, BlockPos to) {
        Vec3 a = Vec3.m_82512_((Vec3i)from);
        Vec3 b = Vec3.m_82512_((Vec3i)to);
        Vec3 v = b.m_82546_(a);
        return (float)Mth.m_14175_((double)Math.toDegrees(Mth.m_14136_((double)(-v.f_82479_), (double)v.f_82481_)));
    }

    public static enum RequestType {
        DISCOVER,
        TRACK;

    }

    private record ScannerState(DepositScannerClientHandler.AntennaStatus antennaStatus, int interval, boolean found) {
    }
}

