/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.mining.MiningBlockEntity;
import com.bmaster.createrns.mining.MiningBlockEntityInstanceHolder;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public abstract class MiningBlock
extends KineticBlock {
    public MiningBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (level.f_46443_ || oldState.m_60713_(state.m_60734_()) || !((blockEntity = level.m_7702_(pos)) instanceof MiningBlockEntity)) {
            return;
        }
        MiningBlockEntity be = (MiningBlockEntity)blockEntity;
        be.reserveDepositBlocks();
        be.notifyUpdate();
    }

    @ParametersAreNonnullByDefault
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        Set<MiningBlockEntity> nearbyMiningBEs = null;
        if (!state.m_60713_(newState.m_60734_()) && (be = level.m_7702_(pos)) instanceof MiningBlockEntity) {
            MiningBlockEntity minerBE = (MiningBlockEntity)be;
            be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    ItemStack stack = iItemHandler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
            });
            if (!level.f_46443_) {
                nearbyMiningBEs = MiningBlockEntityInstanceHolder.getInstancesWithIntersectingMiningArea(minerBE);
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
        if (nearbyMiningBEs != null) {
            for (MiningBlockEntity m : nearbyMiningBEs) {
                m.reserveDepositBlocks();
                m.notifyUpdate();
            }
        }
    }
}

