/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.RNSTags;
import com.bmaster.createrns.mining.MiningAreaOutlineRenderer;
import com.bmaster.createrns.mining.MiningBlockEntityInstanceHolder;
import com.bmaster.createrns.mining.MiningEntityItemHandler;
import com.bmaster.createrns.mining.MiningLevel;
import com.bmaster.createrns.mining.MiningProcess;
import com.bmaster.createrns.mining.MiningRecipeLookup;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class MiningBlockEntity
extends KineticBlockEntity {
    public Set<BlockPos> reservedDepositBlocks = new HashSet<BlockPos>();
    protected MiningProcess process = null;
    protected final MiningEntityItemHandler inventory = new MiningEntityItemHandler(() -> {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
            this.notifyUpdate();
        }
    });
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.empty();
    private CompoundTag miningProgressTag = null;

    public MiningBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract int getMiningAreaRadius();

    public abstract int getMiningAreaDepth();

    public abstract int getMiningAreaYOffset();

    public abstract int getCurrentProgressIncrement();

    public abstract int getBaseProgress();

    public abstract boolean isMining();

    public abstract MiningLevel getMiningLevel();

    public MiningEntityItemHandler getInventory() {
        return this.inventory;
    }

    public BoundingBox getMiningArea(@NotNull Level l) {
        BlockPos pos = this.m_58899_();
        int px = pos.m_123341_();
        int py = pos.m_123342_();
        int pz = pos.m_123343_();
        int minBuildHeight = l.m_141937_();
        int maxBuildHeight = l.m_151558_();
        int mineRadius = this.getMiningAreaRadius();
        int yMin = Mth.m_14045_((int)(py + this.getMiningAreaYOffset() - this.getMiningAreaDepth() + 1), (int)minBuildHeight, (int)maxBuildHeight);
        int yMax = Mth.m_14045_((int)(py + this.getMiningAreaYOffset()), (int)minBuildHeight, (int)maxBuildHeight);
        return new BoundingBox(px - mineRadius, yMin, pz - mineRadius, px + mineRadius, yMax, pz + mineRadius);
    }

    public void reserveDepositBlocks() {
        if (this.f_58857_ == null) {
            return;
        }
        MiningLevel ml = this.getMiningLevel();
        this.reservedDepositBlocks = this.getDepositVein().stream().filter(pos -> MiningRecipeLookup.isDepositMineable(this.f_58857_, this.f_58857_.m_8055_(pos).m_60734_(), ml)).collect(Collectors.toSet());
        for (MiningBlockEntity m : MiningBlockEntityInstanceHolder.getInstancesWithIntersectingMiningArea(this)) {
            this.reservedDepositBlocks.removeAll(m.reservedDepositBlocks);
        }
        if (this.process != null && this.f_58857_ != null) {
            this.process.setYields(this.f_58857_, this.reservedDepositBlocks, this.getBaseProgress());
        }
        this.m_6596_();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.process == null) {
            this.process = new MiningProcess(this.f_58857_, this.getMiningLevel(), this.reservedDepositBlocks, this.getBaseProgress());
            if (this.miningProgressTag != null) {
                this.process.setProgressFromNBT(this.miningProgressTag);
                this.miningProgressTag = null;
            }
        }
        if (this.isMining() && !this.f_58857_.f_46443_) {
            this.process.advance(this.getCurrentProgressIncrement());
            this.inventory.collectMinedItems(this.process);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.inventoryCap = LazyOptional.of(() -> this.inventory);
        MiningBlockEntityInstanceHolder.addInstance(this);
    }

    public void invalidate() {
        super.invalidate();
        this.inventoryCap.invalidate();
        MiningBlockEntityInstanceHolder.removeInstance(this);
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            MiningAreaOutlineRenderer.removeMiningBE(this);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void write(@NotNull CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        long[] packed = this.reservedDepositBlocks.stream().mapToLong(BlockPos::m_121878_).toArray();
        tag.m_128388_("ReservedDepositBlocks", packed);
    }

    public void read(@NotNull CompoundTag tag, boolean clientPacket) {
        long[] packed;
        super.read(tag, clientPacket);
        if (clientPacket) {
            CreateRNS.LOGGER.trace("Client mining BE synced at {}, {}", (Object)this.f_58858_.m_123341_(), (Object)this.f_58858_.m_123343_());
        }
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        if (clientPacket) {
            MiningAreaOutlineRenderer.removeMiningBE(this);
        }
        this.reservedDepositBlocks.clear();
        for (long l : packed = tag.m_128467_("ReservedDepositBlocks")) {
            this.reservedDepositBlocks.add(BlockPos.m_122022_((long)l));
        }
        if (clientPacket) {
            MiningAreaOutlineRenderer.addMiningBE(this);
        }
        if (this.process != null && this.f_58857_ != null) {
            this.process.setYields(this.f_58857_, this.reservedDepositBlocks, this.getBaseProgress());
        }
    }

    private Set<BlockPos> getDepositVein() {
        if (this.f_58857_ == null) {
            return Set.of();
        }
        TagKey<Block> depTag = RNSTags.Block.DEPOSIT_BLOCKS;
        BoundingBox ma = this.getMiningArea(this.f_58857_);
        ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
        LongOpenHashSet visited = new LongOpenHashSet(ma.m_71056_() * ma.m_71057_() * ma.m_71058_());
        q.offer(this.f_58858_.m_5487_(Direction.Axis.Y, this.getMiningAreaYOffset()));
        while (!q.isEmpty()) {
            BlockPos bp = (BlockPos)q.poll();
            if (visited.contains(bp.m_121878_()) || !ma.m_71051_((Vec3i)bp) || !this.f_58857_.m_8055_(bp).m_204336_(depTag)) continue;
            visited.add(bp.m_121878_());
            Direction.m_235666_().forEach(d -> q.add(bp.m_121945_(d)));
        }
        return visited.longStream().mapToObj(BlockPos::m_122022_).collect(Collectors.toSet());
    }
}

