/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.mining.MiningBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class MiningBlockEntityInstanceHolder {
    private static final Object2ObjectOpenHashMap<Level, ObjectOpenHashSet<MiningBlockEntity>> INSTANCES = new Object2ObjectOpenHashMap();

    public static Set<MiningBlockEntity> getInstances(Level level) {
        ObjectOpenHashSet levelSet = (ObjectOpenHashSet)INSTANCES.get((Object)level);
        if (levelSet == null) {
            return Set.of();
        }
        return levelSet.stream().collect(Collectors.toUnmodifiableSet());
    }

    public static Set<MiningBlockEntity> getInstancesWithinManhattanDistance(Level level, BlockPos pos, int distance) {
        ObjectOpenHashSet levelSet = (ObjectOpenHashSet)INSTANCES.get((Object)level);
        if (levelSet == null) {
            return Set.of();
        }
        return levelSet.stream().filter(i -> i.m_58899_().m_123333_((Vec3i)pos) <= distance).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<MiningBlockEntity> getInstancesWithIntersectingMiningArea(MiningBlockEntity be) {
        Level l = be.m_58904_();
        if (l == null) {
            return Set.of();
        }
        ObjectOpenHashSet levelSet = (ObjectOpenHashSet)INSTANCES.get((Object)l);
        if (levelSet == null) {
            return Set.of();
        }
        BlockPos pos = be.m_58899_();
        BoundingBox bb = be.getMiningArea(l);
        return levelSet.stream().filter(m -> !m.m_58899_().equals((Object)pos) && m.getMiningArea(l).m_71049_(bb)).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<MiningBlockEntity> getInstancesThatCouldMine(Level l, BlockPos bp) {
        ObjectOpenHashSet levelSet = (ObjectOpenHashSet)INSTANCES.get((Object)l);
        if (levelSet == null) {
            return Set.of();
        }
        return levelSet.stream().filter(m -> m.getMiningArea(l).m_71051_((Vec3i)bp)).collect(Collectors.toUnmodifiableSet());
    }

    protected static void addInstance(MiningBlockEntity be) {
        Level l = be.m_58904_();
        if (l == null) {
            return;
        }
        ((ObjectOpenHashSet)INSTANCES.computeIfAbsent((Object)l, k -> new ObjectOpenHashSet())).add((Object)be);
    }

    protected static void removeInstance(MiningBlockEntity be) {
        Level l = be.m_58904_();
        if (l == null) {
            return;
        }
        ObjectOpenHashSet levelSet = (ObjectOpenHashSet)INSTANCES.get((Object)l);
        levelSet.remove((Object)be);
        if (levelSet.isEmpty()) {
            INSTANCES.remove((Object)l);
        }
    }
}

