/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.mining.MiningProcess;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MiningEntityItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    private static final int MAX_COUNT_PER_TYPE = 64;
    private List<Item> types;
    private final Object2ObjectOpenHashMap<Item, ItemStack> typeToStack;
    private final Runnable onContentsChangedRunnable;

    public MiningEntityItemHandler(Runnable onContentsChanged) {
        this.types = new ArrayList<Item>();
        this.typeToStack = new Object2ObjectOpenHashMap();
        this.onContentsChangedRunnable = onContentsChanged;
    }

    public MiningEntityItemHandler(List<Item> slotTypes, Runnable onContentsChanged) {
        this.types = new ArrayList<Item>(slotTypes);
        this.typeToStack = slotTypes.stream().collect(Collectors.toMap(i -> i, i -> ItemStack.f_41583_, (o, n) -> n, () -> new Object2ObjectOpenHashMap(slotTypes.size())));
        this.onContentsChangedRunnable = onContentsChanged;
    }

    public boolean isEmpty() {
        return this.typeToStack.values().stream().allMatch(ItemStack::m_41619_);
    }

    public int getSlots() {
        return this.typeToStack.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack stack = (ItemStack)this.typeToStack.get((Object)this.types.get(slot));
        return stack.m_41613_() > 0 ? stack.m_41777_() : ItemStack.f_41583_;
    }

    public void collectMinedItems(MiningProcess process) {
        if (process == null) {
            return;
        }
        boolean invUpdated = false;
        for (ItemStack minedStack : process.collect()) {
            ItemStack existingStack;
            Item minedType = minedStack.m_41720_();
            int minedCount = minedStack.m_41613_();
            if (this.typeToStack.containsKey((Object)minedType)) {
                existingStack = (ItemStack)this.typeToStack.get((Object)minedType);
                int existingCount = existingStack.m_41613_();
                int updatedCount = Math.min(64, existingCount + minedCount);
                existingStack.m_41764_(updatedCount);
                invUpdated = updatedCount != existingCount;
            } else {
                existingStack = minedStack;
                existingStack.m_41764_(Math.min(64, minedCount));
                this.types.add(0, minedType);
                this.typeToStack.put((Object)minedType, (Object)minedStack);
                invUpdated = true;
            }
            if (invUpdated) {
                CreateRNS.LOGGER.trace("Mined {}", (Object)existingStack.m_41720_());
                continue;
            }
            CreateRNS.LOGGER.trace("Could not mine {}", (Object)existingStack.m_41720_());
        }
        if (invUpdated) {
            this.onContentsChanged();
        }
    }

    @NotNull
    public ItemStack extractFirstAvailableItem(boolean simulate) {
        for (Map.Entry e : this.typeToStack.entrySet()) {
            ItemStack stack = (ItemStack)e.getValue();
            if (stack.m_41619_()) continue;
            ItemStack newStack = stack.m_255036_(1);
            if (!simulate) {
                stack.m_41774_(1);
                this.onContentsChanged();
            }
            return newStack;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack newStack;
        if (slot >= this.types.size()) {
            return ItemStack.f_41583_;
        }
        Item type = this.types.get(slot);
        ItemStack existingStack = (ItemStack)this.typeToStack.get((Object)type);
        int existingStackCount = existingStack.m_41613_();
        int extractedCount = Math.min(amount, existingStackCount);
        int updatedCount = existingStackCount - extractedCount;
        if (!simulate && updatedCount != existingStackCount) {
            newStack = existingStack.m_255036_(extractedCount);
            if (updatedCount > 0) {
                existingStack.m_41764_(updatedCount);
            } else {
                this.types.remove(type);
                this.typeToStack.remove((Object)type);
            }
            this.onContentsChanged();
        } else {
            newStack = ItemStack.f_41583_;
        }
        return newStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, boolean simulate) {
        return this.extractItem(slot, 64, simulate);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return false;
    }

    private void onContentsChanged() {
        this.onContentsChangedRunnable.run();
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.types.size(); ++i) {
            Item type = this.types.get(i);
            ItemStack stack = (ItemStack)this.typeToStack.get((Object)type);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.typeToStack.clear();
        ListTag tagList = nbt.m_128437_("Items", 10);
        List<CompoundTag> tags = IntStream.range(0, tagList.size()).mapToObj(arg_0 -> ((ListTag)tagList).m_128728_(arg_0)).toList();
        this.types = new ArrayList<Item>(tags.size());
        for (CompoundTag t : tags) {
            int slot = t.m_128451_("Slot");
            if (0 > slot || slot >= tags.size()) continue;
            ItemStack newStack = ItemStack.m_41712_((CompoundTag)t);
            Item newType = newStack.m_41720_();
            this.types.add(slot, newType);
            this.typeToStack.put((Object)newType, (Object)newStack);
        }
    }
}

