/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.RNSTags;
import com.bmaster.createrns.mining.MiningLevel;
import com.bmaster.createrns.mining.MiningRecipeLookup;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MiningProcess {
    public final MiningLevel miningLevel;
    public final Set<SingleTypeProcess> innerProcesses = new ObjectOpenHashSet();

    public MiningProcess(Level l, MiningLevel ml, Set<BlockPos> depositBlocks, int baseProgress) {
        this.miningLevel = ml;
        this.setYields(l, depositBlocks, baseProgress);
    }

    public boolean isPossible() {
        return !this.innerProcesses.isEmpty();
    }

    public void advance(int by) {
        if (!this.isPossible()) {
            return;
        }
        this.innerProcesses.forEach(p -> p.advance(by));
    }

    public Set<ItemStack> collect() {
        return this.innerProcesses.stream().map(SingleTypeProcess::collect).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void setYields(Level l, Set<BlockPos> depositBlocks, int baseProgress) {
        Map yieldCounts = depositBlocks.stream().map(bp -> l.m_8055_(bp).m_60734_()).filter(db -> db.m_49966_().m_204336_(RNSTags.Block.DEPOSIT_BLOCKS)).map(db -> MiningRecipeLookup.getYield(l, this.miningLevel, db)).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        this.innerProcesses.clear();
        for (Map.Entry e : yieldCounts.entrySet()) {
            int depBlockCount = e.getValue().intValue();
            this.innerProcesses.add(new SingleTypeProcess((Item)e.getKey(), baseProgress / depBlockCount));
        }
    }

    public CompoundTag getProgressAsNBT() {
        CompoundTag mpTag = new CompoundTag();
        ListTag stpTags = new ListTag();
        this.innerProcesses.stream().map(SingleTypeProcess::getProgressAsNBT).filter(Objects::nonNull).forEach(arg_0 -> stpTags.add(arg_0));
        mpTag.m_128365_("PerYieldProgress", (Tag)stpTags);
        return mpTag;
    }

    public void setProgressFromNBT(CompoundTag nbt) {
        Object2ObjectOpenHashMap yieldToProcess = this.innerProcesses.stream().collect(Collectors.toMap(p -> p.yield, p -> p, (o, n) -> n, Object2ObjectOpenHashMap::new));
        ListTag yieldProgressTags = nbt.m_128437_("PerYieldProgress", 10);
        for (Tag stp : yieldProgressTags) {
            String yieldStr = ((CompoundTag)stp).m_128461_("Yield");
            ResourceLocation yieldRL = ResourceLocation.m_135820_((String)yieldStr);
            if (yieldRL == null) {
                CreateRNS.LOGGER.error("Could not parse resource location '{}' when deserializing mining process", (Object)yieldStr);
                continue;
            }
            Item yield = (Item)ForgeRegistries.ITEMS.getValue(yieldRL);
            if (yield == null) {
                CreateRNS.LOGGER.error("Unknown item '{}' encountered when deserializing mining process", (Object)yieldStr);
                continue;
            }
            ((SingleTypeProcess)yieldToProcess.get((Object)yield)).setProgressFromNBT((CompoundTag)stp);
        }
    }

    public static class SingleTypeProcess {
        public final Item yield;
        public int maxProgress;
        public int progress;

        public SingleTypeProcess(Item yield, int maxProgress) {
            this.yield = yield;
            this.maxProgress = maxProgress;
            this.progress = 0;
        }

        public void advance(int by) {
            assert (by > 0);
            this.progress += by;
        }

        @Nullable
        public ItemStack collect() {
            if (this.progress < this.maxProgress) {
                return null;
            }
            this.progress -= this.maxProgress;
            return new ItemStack((ItemLike)this.yield);
        }

        @Nullable
        public CompoundTag getProgressAsNBT() {
            ResourceLocation yieldRL = ForgeRegistries.ITEMS.getKey((Object)this.yield);
            if (yieldRL == null) {
                return null;
            }
            CompoundTag stpTag = new CompoundTag();
            stpTag.m_128359_("Yield", yieldRL.toString());
            stpTag.m_128405_("Progress", this.progress);
            stpTag.m_128405_("MaxProgress", this.maxProgress);
            return stpTag;
        }

        public void setProgressFromNBT(CompoundTag nbt) {
            this.progress = nbt.m_128451_("Progress");
            this.maxProgress = nbt.m_128451_("MaxProgress");
        }
    }
}

