/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.RNSRecipeTypes;
import com.bmaster.createrns.mining.MiningLevel;
import com.bmaster.createrns.mining.recipe.MiningRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class MiningRecipeLookup {
    private static Object2ObjectOpenHashMap<Block, Item> depBlockToYieldBasic;
    private static Object2ObjectOpenHashMap<Block, Item> depBlockToYieldAdvanced;

    @Nullable
    public static Item getYield(Level l, MiningLevel ml, Block depositBlock) {
        Item res;
        if (depBlockToYieldBasic == null) {
            MiningRecipeLookup.build(l);
        }
        return (res = (Item)depBlockToYieldBasic.get((Object)depositBlock)) != null ? res : (Item)depBlockToYieldAdvanced.get((Object)depositBlock);
    }

    public static boolean isDepositMineable(Level l, Block depositBlock, MiningLevel ml) {
        if (depBlockToYieldBasic == null) {
            MiningRecipeLookup.build(l);
        }
        if (ml.getLevel() >= MiningLevel.BASIC.getLevel() && depBlockToYieldBasic.containsKey((Object)depositBlock)) {
            return true;
        }
        return ml.getLevel() >= MiningLevel.ADVANCED.getLevel() && depBlockToYieldAdvanced.containsKey((Object)depositBlock);
    }

    public static void build(Level l) {
        List basicRecipes = l.m_7465_().m_44013_((RecipeType)RNSRecipeTypes.BASIC_MINING_TYPE.get());
        List advancedRecipes = l.m_7465_().m_44013_((RecipeType)RNSRecipeTypes.ADVANCED_MINING_TYPE.get());
        depBlockToYieldBasic = basicRecipes.stream().collect(Collectors.toMap(MiningRecipe::getDepositBlock, MiningRecipe::getYield, (o, n) -> n, Object2ObjectOpenHashMap::new));
        depBlockToYieldAdvanced = advancedRecipes.stream().collect(Collectors.toMap(MiningRecipe::getDepositBlock, MiningRecipe::getYield, (o, n) -> n, Object2ObjectOpenHashMap::new));
    }
}

