/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining.miner;

import com.bmaster.createrns.mining.MiningBlockEntity;
import com.bmaster.createrns.mining.MiningProcess;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Comparator;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public abstract class MinerBlockEntity
extends MiningBlockEntity {
    private List<BlockState> particleOptions = null;

    public MinerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getCurrentProgressIncrement() {
        return (int)Math.abs(this.getSpeed());
    }

    @Override
    public boolean isMining() {
        if (this.f_58857_ == null || this.process == null) {
            return false;
        }
        return !this.reservedDepositBlocks.isEmpty() && this.isSpeedRequirementFulfilled();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.isMining()) {
                this.spawnParticles();
            }
        } else {
            this.tryEjectUp();
        }
    }

    public void tickAudio() {
        if (!this.isMining()) {
            return;
        }
        float speed = Math.abs(this.getSpeed());
        float pitch = Mth.m_14036_((float)(speed / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.CRUSHING, (BlockPos)this.f_58858_, (float)pitch);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = false;
        added = !isPlayerSneaking ? this.addInventoryToGoggleTooltip(tooltip, true) : this.addRatesToGoggleTooltip(tooltip, true);
        if (!added) {
            added = !isPlayerSneaking ? this.addRatesToGoggleTooltip(tooltip, true) : this.addInventoryToGoggleTooltip(tooltip, true);
        }
        added = this.addKineticsToGoggleTooltip(tooltip, !added);
        return added;
    }

    protected void addStressImpactStats(List<Component> tooltip, float stressAtBase) {
        super.addStressImpactStats(tooltip, stressAtBase);
    }

    protected boolean addInventoryToGoggleTooltip(List<Component> tooltip, boolean isMainSection) {
        if (this.inventory.isEmpty()) {
            return false;
        }
        if (isMainSection) {
            new LangBuilder("create_rns").translate("miner.contents", new Object[0]).forGoggles(tooltip);
        } else {
            new LangBuilder("create_rns").space().forGoggles(tooltip);
        }
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack is = this.inventory.getStackInSlot(slot);
            if (is.equals(ItemStack.f_41583_)) continue;
            new LangBuilder("create_rns").add(is.m_41786_().m_6881_().m_130940_(ChatFormatting.GRAY)).add(Component.m_237113_((String)(" x" + is.m_41613_())).m_130940_(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected boolean addRatesToGoggleTooltip(List<Component> tooltip, boolean isMainSection) {
        if (this.process == null || this.reservedDepositBlocks.isEmpty()) {
            return false;
        }
        if (isMainSection) {
            new LangBuilder("create_rns").translate("miner.production_rates", new Object[0]).forGoggles(tooltip);
        } else {
            new LangBuilder("create_rns").space().forGoggles(tooltip);
        }
        List<MiningProcess.SingleTypeProcess> stpListSorted = this.process.innerProcesses.stream().sorted(Comparator.comparingInt(p -> p.maxProgress)).toList();
        for (MiningProcess.SingleTypeProcess p2 : stpListSorted) {
            int progressPerHour = 72000 * this.getCurrentProgressIncrement();
            float itemsPerHour = (float)((long)progressPerHour * 10L / (long)p2.maxProgress) / 10.0f;
            new LangBuilder("create_rns").add(p2.yield.m_41466_().m_6881_().m_130946_(": ").m_130940_(ChatFormatting.GRAY)).add(Component.m_237113_((String)Float.toString(itemsPerHour)).m_7220_((Component)Component.m_237115_((String)"%s.miner.per_hour".formatted("create_rns"))).m_130940_(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected boolean addKineticsToGoggleTooltip(List<Component> tooltip, boolean isMainSection) {
        float stressAtBase = 0.0f;
        if (IRotate.StressImpact.isEnabled()) {
            stressAtBase = this.calculateStressApplied();
        }
        if (Mth.m_14033_((float)stressAtBase, (float)0.0f)) {
            return false;
        }
        if (isMainSection) {
            CreateLang.translate((String)"gui.goggles.kinetic_stats", (Object[])new Object[0]).forGoggles(tooltip);
        } else {
            new LangBuilder("create_rns").space().forGoggles(tooltip);
        }
        this.addStressImpactStats(tooltip, this.calculateStressApplied());
        return true;
    }

    protected void tryEjectUp() {
        IItemHandler targetInv;
        InvManipulationBehaviour inserter;
        if (this.f_58857_ == null) {
            return;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        InvManipulationBehaviour invManipulationBehaviour = inserter = be == null ? null : (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)InvManipulationBehaviour.TYPE);
        IItemHandler iItemHandler = be == null ? null : (targetInv = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory()));
        if (targetInv == null) {
            return;
        }
        ItemStack extracted = this.inventory.extractFirstAvailableItem(true);
        if (extracted.m_41619_()) {
            return;
        }
        for (int i = 0; i < targetInv.getSlots(); ++i) {
            ItemStack remaining = targetInv.insertItem(i, extracted, true);
            if (!remaining.m_41619_()) continue;
            extracted = this.inventory.extractFirstAvailableItem(false);
            assert (!extracted.m_41619_());
            remaining = targetInv.insertItem(i, extracted, false);
            assert (remaining.m_41619_());
            return;
        }
    }

    protected void spawnParticles() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.particleOptions == null) {
            this.particleOptions = this.reservedDepositBlocks.stream().map(bp -> this.f_58857_.m_8055_(bp)).toList();
        }
        RandomSource r = this.f_58857_.f_46441_;
        BlockState selectedParticle = this.particleOptions.get(r.m_216339_(0, this.particleOptions.size()));
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, selectedParticle);
        for (int i = 0; i < 2; ++i) {
            this.f_58857_.m_7106_((ParticleOptions)particleData, (double)((float)this.f_58858_.m_123341_() + r.m_188501_()), (double)this.f_58858_.m_123342_() - 0.5 + (double)r.m_188501_(), (double)((float)this.f_58858_.m_123343_() + r.m_188501_()), 0.0, 0.0, 0.0);
        }
    }
}

