/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining.recipe;

import com.bmaster.createrns.RNSRecipeTypes;
import com.bmaster.createrns.mining.recipe.MiningRecipe;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AdvancedMiningRecipe
extends MiningRecipe {
    public AdvancedMiningRecipe(ResourceLocation id, Block depositBlock, Item yield) {
        super(id, depositBlock, yield);
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RNSRecipeTypes.ADVANCED_MINING_SERIALIZER.get();
    }

    @Override
    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RNSRecipeTypes.ADVANCED_MINING_TYPE.get();
    }

    @ParametersAreNonnullByDefault
    public static class Serializer
    extends MiningRecipe.Serializer<AdvancedMiningRecipe> {
        @NotNull
        public AdvancedMiningRecipe fromJson(ResourceLocation id, JsonObject json) {
            Block depBlock = Serializer.parseBlockId(json, "deposit_block");
            Item yield = Serializer.parseItemId(json, "yield");
            return new AdvancedMiningRecipe(id, depBlock, yield);
        }

        public AdvancedMiningRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Block depBlock = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(buf.m_130281_()));
            ItemStack yield = buf.m_130267_();
            return new AdvancedMiningRecipe(id, depBlock, yield.m_41720_());
        }

        public void toNetwork(FriendlyByteBuf buf, AdvancedMiningRecipe r) {
            buf.m_130085_(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)r.getDepositBlock())));
            buf.m_130055_(new ItemStack((ItemLike)r.getYield()));
        }
    }
}

