/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class MiningRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Block depositBlock;
    private final Item yield;

    public MiningRecipe(ResourceLocation id, Block depositBlock, Item yield) {
        this.id = id;
        this.depositBlock = depositBlock;
        this.yield = yield;
    }

    @NotNull
    public abstract RecipeSerializer<?> m_7707_();

    @NotNull
    public abstract RecipeType<?> m_6671_();

    public Block getDepositBlock() {
        return this.depositBlock;
    }

    public Item getYield() {
        return this.yield;
    }

    @ParametersAreNonnullByDefault
    public boolean m_5818_(Container c, Level l) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_5874_(Container c, RegistryAccess ra) {
        return new ItemStack((ItemLike)this.yield);
    }

    public boolean m_8004_(int w, int h) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_8043_(RegistryAccess ra) {
        return new ItemStack((ItemLike)this.yield);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.depositBlock})});
    }

    public boolean m_5598_() {
        return true;
    }

    @ParametersAreNonnullByDefault
    public static abstract class Serializer<MR extends MiningRecipe>
    implements RecipeSerializer<MR> {
        protected static Block parseBlockId(JsonObject json, String field) {
            String raw = GsonHelper.m_13906_((JsonObject)json, (String)field);
            ResourceLocation rl = ResourceLocation.m_135820_((String)raw);
            if (rl == null) {
                throw new JsonSyntaxException("Invalid resource location for '%s': %s".formatted(field, raw));
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
            if (block == null || block == Blocks.f_50016_) {
                throw new JsonSyntaxException("Unknown block for '%s': %s".formatted(field, raw));
            }
            return block;
        }

        protected static Item parseItemId(JsonObject json, String field) {
            String raw = GsonHelper.m_13906_((JsonObject)json, (String)field);
            ResourceLocation rl = ResourceLocation.m_135820_((String)raw);
            if (rl == null) {
                throw new JsonSyntaxException("Invalid resource location for '%s': %s".formatted(field, raw));
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
            if (item == null || item == Items.f_41852_) {
                throw new JsonSyntaxException("Unknown item for '%s': %s".formatted(field, raw));
            }
            return item;
        }
    }
}

