/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.data.pack;

import com.bmaster.createrns.CreateRNS;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;

public final class DynamicDatapackResources
implements PackResources {
    private final PackLocationInfo info;
    private final Map<ResourceLocation, byte[]> serverData = new Object2ObjectOpenHashMap();
    private final PackMetadataSection metadata;

    public DynamicDatapackResources(PackLocationInfo info) {
        this.info = info;
        int packFormat = SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA);
        this.metadata = new PackMetadataSection((Component)Component.literal((String)info.id()), packFormat);
    }

    public void putJson(String path, JsonElement json) {
        this.serverData.put(DynamicDatapackResources.loc(path), CreateRNS.GSON.toJson(json).getBytes(StandardCharsets.UTF_8));
    }

    private static ResourceLocation loc(String path) {
        int idx = path.indexOf(47);
        String ns = path.substring(0, idx);
        String p = path.substring(idx + 1);
        return ResourceLocation.fromNamespaceAndPath((String)ns, (String)p);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Set<String> getNamespaces(PackType type) {
        if (type != PackType.SERVER_DATA) {
            return Set.of();
        }
        return this.serverData.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet());
    }

    @NotNull
    public PackLocationInfo location() {
        return this.info;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation rl) {
        if (type != PackType.SERVER_DATA) {
            return null;
        }
        byte[] b = this.serverData.get(rl);
        return b == null ? null : () -> new ByteArrayInputStream(b);
    }

    @ParametersAreNonnullByDefault
    public void listResources(PackType type, String ns, String path, PackResources.ResourceOutput out) {
        if (type != PackType.SERVER_DATA) {
            return;
        }
        Object pathWithSlash = path.endsWith("/") ? path : path + "/";
        for (Map.Entry<ResourceLocation, byte[]> e : this.serverData.entrySet()) {
            ResourceLocation rl = e.getKey();
            if (!rl.getNamespace().equals(ns) || !rl.getPath().startsWith((String)pathWithSlash)) continue;
            out.accept((Object)e.getKey(), () -> new ByteArrayInputStream((byte[])e.getValue()));
        }
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        if (elements.length == 1 && "pack.mcmeta".equals(elements[0])) {
            byte[] bytes = this.buildPackMcMetaBytes();
            return () -> new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) {
        if (deserializer == PackMetadataSection.TYPE) {
            PackMetadataSection t = this.metadata;
            return (T)t;
        }
        return null;
    }

    private byte[] buildPackMcMetaBytes() {
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", this.metadata.description().toString());
        pack.addProperty("pack_format", (Number)this.metadata.packFormat());
        root.add("pack", (JsonElement)pack);
        return CreateRNS.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8);
    }

    public void close() {
    }
}

