/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.data.pack.json;

import com.google.gson.annotations.SerializedName;
import java.util.List;

public class ReplaceWithProcessor {
    @SerializedName(value="processors")
    public List<Processor> processors;

    public ReplaceWithProcessor(String matchBlockId, String replaceWithBlockId) {
        Processor processor = new Processor(matchBlockId, replaceWithBlockId);
        this.processors = List.of(processor);
    }

    public static class Processor {
        @SerializedName(value="processor_type")
        public String processorType = "minecraft:rule";
        @SerializedName(value="rules")
        public List<Rule> rules;

        public Processor(String matchBlockId, String replaceWithBlockId) {
            Rule rule = new Rule(new BlockMatchPredicate(matchBlockId), new AlwaysTruePredicate(), new OutputState(replaceWithBlockId));
            this.rules = List.of(rule);
        }
    }

    public static class OutputState {
        @SerializedName(value="Name")
        public String name;

        public OutputState(String name) {
            this.name = name;
        }
    }

    public static class AlwaysTruePredicate {
        @SerializedName(value="predicate_type")
        public String predicateType = "minecraft:always_true";
    }

    public static class BlockMatchPredicate {
        @SerializedName(value="predicate_type")
        public String predicateType = "minecraft:block_match";
        public String block;

        public BlockMatchPredicate(String block) {
            this.block = block;
        }
    }

    public static class Rule {
        @SerializedName(value="input_predicate")
        public BlockMatchPredicate inputPredicate;
        @SerializedName(value="location_predicate")
        public AlwaysTruePredicate locationPredicate;
        @SerializedName(value="output_state")
        public OutputState outputState;

        public Rule(BlockMatchPredicate in, AlwaysTruePredicate loc, OutputState out) {
            this.inputPredicate = in;
            this.locationPredicate = loc;
            this.outputState = out;
        }
    }
}

