/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.event;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.RNSRecipes;
import com.bmaster.createrns.data.pack.DynamicDatapack;
import com.bmaster.createrns.deposit.LevelDepositData;
import com.bmaster.createrns.deposit.spec.DepositSpec;
import com.bmaster.createrns.deposit.spec.DepositSpecLookup;
import com.bmaster.createrns.item.DepositScanner.DepositScannerC2SPayload;
import com.bmaster.createrns.item.DepositScanner.DepositScannerS2CPayload;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber(modid="create_rns")
public class CommonEvents {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent e) {
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RNSContent.MINER_MK1_BE.get(), (be, side) -> be.getItemHandler((Direction)side));
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RNSContent.MINER_MK2_BE.get(), (be, side) -> be.getItemHandler((Direction)side));
    }

    @SubscribeEvent
    public static void onNewRegistry(DataPackRegistryEvent.NewRegistry e) {
        e.dataPackRegistry(DepositSpec.REGISTRY_KEY, DepositSpec.CODEC, DepositSpec.CODEC);
    }

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent e) {
        if (e.getPackType() != PackType.SERVER_DATA) {
            return;
        }
        DynamicDatapack.addDepositBiomeTag();
        DynamicDatapack.addVanillaDeposits();
        DynamicDatapack.addDepositSetAndTag();
        e.addRepositorySource(consumer -> consumer.accept(DynamicDatapack.finish()));
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)RNSContent.MINER_MK1_DRILL.modelLocation()));
        event.register(ModelResourceLocation.standalone((ResourceLocation)RNSContent.MINER_MK2_DRILL.modelLocation()));
    }

    @SubscribeEvent
    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(DepositScannerC2SPayload.TYPE, DepositScannerC2SPayload.STREAM_CODEC, DepositScannerC2SPayload::handle);
        registrar.playToClient(DepositScannerS2CPayload.TYPE, DepositScannerS2CPayload.STREAM_CODEC, DepositScannerS2CPayload::handle);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new RNSRecipes.Washing(output, provider));
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)levelAccessor;
        LevelDepositData depData = (LevelDepositData)sl.getData(RNSContent.LEVEL_DEPOSIT_DATA.get());
        ChunkPos pos = e.getChunk().getPos();
        StructureManager sm = sl.structureManager();
        for (StructureStart start : sm.startsForStructure(pos, DepositSpecLookup.isDeposit(sl.registryAccess()))) {
            sl.registryAccess().registryOrThrow(Registries.STRUCTURE).getResourceKey((Object)start.getStructure()).ifPresent(structKey -> depData.add((ResourceKey<Structure>)structKey, start, sl));
        }
    }
}

