/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.infrastructure;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="create_rns")
public class ServerConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.ConfigValue<Float> MINER_MK1_SPEED_CV = BUILDER.comment(" How many mining operations a miner mk1 can complete in one hour\n at 256 RPM, with one deposit block claimed, and no deposit multipliers").define("minerSpeed", (Object)Float.valueOf(45.0f));
    private static final ModConfigSpec.ConfigValue<Float> MINER_MK2_SPEED_CV = BUILDER.comment(" How many mining operations a miner mk2 can complete in one hour\n at 256 RPM, with one deposit block claimed, and no deposit multipliers").define("minerSpeed", (Object)Float.valueOf(45.0f));
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static int minerMk1BaseProgress;
    public static int minerMk2BaseProgress;

    @SubscribeEvent
    static void onLoadReload(ModConfigEvent event) {
        if (event instanceof ModConfigEvent.Unloading) {
            return;
        }
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        int ticksPerHour = 72000;
        minerMk1BaseProgress = 256 * ticksPerHour / (int)((Float)MINER_MK1_SPEED_CV.get()).floatValue();
        minerMk2BaseProgress = 256 * ticksPerHour / (int)((Float)MINER_MK2_SPEED_CV.get()).floatValue();
    }
}

