/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.RNSSoundEvents;
import com.bmaster.createrns.deposit.spec.DepositSpecLookup;
import com.bmaster.createrns.item.DepositScanner.DepositScannerC2SPayload;
import com.bmaster.createrns.item.DepositScanner.DepositScannerItemRenderer;
import com.bmaster.createrns.item.DepositScanner.DepositScannerServerHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class DepositScannerClientHandler {
    private static State state = new State();

    public static AntennaStatus getAntennaStatus() {
        return DepositScannerClientHandler.state.antennaStatus;
    }

    public static boolean isTracking() {
        return DepositScannerClientHandler.state.isTracking;
    }

    public static boolean isDepositFound() {
        return DepositScannerClientHandler.state.depositFound;
    }

    public static void cancelTracking(boolean playSound) {
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null) {
            return;
        }
        DepositScannerClientHandler.state.depositFound = false;
        DepositScannerClientHandler.state.isTracking = false;
        if (playSound) {
            RNSSoundEvents.SCANNER_CLICK.playInHand(p.level(), (Vec3i)p.blockPosition());
        }
    }

    public static void discoverDeposit() {
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new DepositScannerC2SPayload(DepositScannerClientHandler.getSelectedItem(), DepositScannerServerHandler.RequestType.DISCOVER), (CustomPacketPayload[])new CustomPacketPayload[0]);
        RNSSoundEvents.SCANNER_CLICK.playInHand(p.level(), (Vec3i)p.blockPosition());
        RNSSoundEvents.SCANNER_DISCOVERY_PING.playInHand(p.level(), (Vec3i)p.blockPosition());
        DepositScannerItemRenderer.shakeItem();
    }

    public static void scrollDown() {
        ++DepositScannerClientHandler.state.selectedIndex;
        DepositScannerItemRenderer.scrollDown();
        DepositScannerClientHandler.afterScroll();
    }

    public static void scrollUp() {
        --DepositScannerClientHandler.state.selectedIndex;
        DepositScannerItemRenderer.scrollUp();
        DepositScannerClientHandler.afterScroll();
    }

    public static void clearState() {
        state = new State();
    }

    public static void tick() {
        if (DepositScannerClientHandler.state.trackingStateUpdatePending) {
            DepositScannerClientHandler.processTrackingStateUpdate();
        }
        DepositScannerItemRenderer.tick();
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        LocalPlayer p = mc.player;
        if (p == null || p.isSpectator()) {
            return;
        }
        ItemStack heldItem = p.getMainHandItem();
        if (!RNSContent.DEPOSIT_SCANNER_ITEM.isIn(heldItem) && !RNSContent.DEPOSIT_SCANNER_ITEM.isIn(heldItem = p.getOffhandItem())) {
            DepositScannerItemRenderer.resetWheel();
            return;
        }
        if (DepositScannerClientHandler.state.depositFound || !DepositScannerClientHandler.state.isTracking) {
            return;
        }
        ++DepositScannerClientHandler.state.ticksSinceLastPing;
        if (DepositScannerClientHandler.state.ticksSinceLastPing >= DepositScannerClientHandler.state.pingInterval) {
            DepositScannerClientHandler.state.ticksSinceLastPing = 0;
            PacketDistributor.sendToServer((CustomPacketPayload)new DepositScannerC2SPayload(DepositScannerClientHandler.getSelectedItem(), DepositScannerServerHandler.RequestType.TRACK), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static ItemStack getSelectedItem() {
        ClientLevel l = Minecraft.getInstance().level;
        if (l == null) {
            return ItemStack.EMPTY;
        }
        List<Item> allItems = DepositSpecLookup.getAllScannerIcons(l.registryAccess());
        int size = allItems.size();
        int normalizedIndex = (DepositScannerClientHandler.state.selectedIndex % size + size) % size;
        return new ItemStack((ItemLike)allItems.get(normalizedIndex));
    }

    protected static void processDiscoverReply(AntennaStatus status) {
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null) {
            return;
        }
        DepositScannerClientHandler.state.isTracking = status != AntennaStatus.INACTIVE;
        DepositScannerClientHandler.state.ticksSinceLastPing = 0;
        DepositScannerClientHandler.state.pingInterval = 60;
        DepositScannerClientHandler.state.trackingStateUpdatePending = false;
        if (DepositScannerClientHandler.state.isTracking) {
            RNSSoundEvents.SCANNER_DISCOVERY_SUCCESS.playInHand(p.level(), (Vec3i)p.blockPosition());
        }
    }

    protected static void processTrackingReply(AntennaStatus status, int interval, boolean found) {
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null || !p.level().isClientSide() || !DepositScannerClientHandler.state.isTracking) {
            return;
        }
        if (status == AntennaStatus.INACTIVE) {
            DepositScannerClientHandler.cancelTracking(false);
            return;
        }
        DepositScannerClientHandler.state.antennaStatus = status;
        DepositScannerClientHandler.state.pingInterval = interval;
        DepositScannerClientHandler.state.trackingStateUpdatePending = true;
        if (found) {
            DepositScannerClientHandler.state.antennaStatus = AntennaStatus.BOTH_ACTIVE;
            DepositScannerClientHandler.state.depositFound = true;
        }
    }

    private static void processTrackingStateUpdate() {
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null || !p.level().isClientSide()) {
            return;
        }
        DepositScannerClientHandler.state.trackingStateUpdatePending = false;
        if (DepositScannerClientHandler.state.depositFound) {
            RNSSoundEvents.DEPOSIT_FOUND.playInHand(p.level(), (Vec3i)p.blockPosition());
            DepositScannerItemRenderer.shakeItem();
            return;
        }
        DepositScannerItemRenderer.powerBriefly();
        int max = 57;
        float pitchMultiplier = 1.0f - (float)(DepositScannerClientHandler.state.pingInterval - 3) / (float)max;
        RNSSoundEvents.SCANNER_TRACKING_PING.playInHand(p.level(), (Vec3i)p.blockPosition(), 1.0f, 0.8f + 0.4f * pitchMultiplier, true);
    }

    private static void afterScroll() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        DepositScannerClientHandler.cancelTracking(false);
        RNSSoundEvents.SCANNER_SCROLL.playInHand(player.level(), (Vec3i)player.blockPosition());
        ResourceLocation dRL = DepositSpecLookup.getStructureKey(player.level().registryAccess(), DepositScannerClientHandler.getSelectedItem().getItem()).location();
        MutableComponent dName = Component.translatable((String)(dRL.getNamespace() + ".structure." + dRL.getPath()));
        player.displayClientMessage((Component)dName, true);
    }

    private static class State {
        private AntennaStatus antennaStatus = AntennaStatus.INACTIVE;
        private int pingInterval = 60;
        private int selectedIndex = 0;
        private int ticksSinceLastPing = this.pingInterval;
        private boolean trackingStateUpdatePending = false;
        private boolean isTracking = false;
        private boolean depositFound = false;

        private State() {
        }
    }

    public static enum AntennaStatus {
        INACTIVE,
        LEFT_ACTIVE,
        RIGHT_ACTIVE,
        BOTH_ACTIVE;

    }
}

