/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.item.DepositScanner.DepositScannerClientHandler;
import com.bmaster.createrns.item.DepositScanner.DepositScannerItemRenderer;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DepositScannerItem
extends Item {
    private static final int SCANNER_USE_COOLDOWN = 100;

    public DepositScannerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new DepositScannerItemRenderer()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!level.isClientSide) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        if (DepositScannerClientHandler.isTracking()) {
            DepositScannerClientHandler.cancelTracking(true);
        } else {
            DepositScannerClientHandler.discoverDeposit();
            player.getCooldowns().addCooldown((Item)RNSContent.DEPOSIT_SCANNER_ITEM.get(), 100);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }
}

