/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.deposit.LevelDepositData;
import com.bmaster.createrns.deposit.spec.DepositSpecLookup;
import com.bmaster.createrns.item.DepositScanner.DepositScannerClientHandler;
import com.bmaster.createrns.item.DepositScanner.DepositScannerS2CPayload;
import com.bmaster.createrns.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class DepositScannerServerHandler {
    public static final int MIN_PING_INTERVAL = 3;
    public static final int MAX_PING_INTERVAL = 60;
    public static final float FOUND_DISTANCE = 5.0f;
    private static final int SEARCH_RADIUS_CHUNKS = 192;
    private static final int MAX_BLOCK_DISTANCE = 3072;

    public static void processScanRequest(ServerPlayer sp, Item icon, RequestType rt) {
        ScannerState state;
        BlockPos nearest;
        Level level = sp.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        LevelDepositData depData = (LevelDepositData)sl.getData(RNSContent.LEVEL_DEPOSIT_DATA.get());
        ResourceKey<Structure> structKey = DepositSpecLookup.getStructureKey(sl.registryAccess(), icon);
        switch (rt.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                BlockPos blockPos = depData.getNearest(structKey, sp, 192);
                break;
            }
            case 1: {
                BlockPos blockPos = nearest = depData.getNearestCached(structKey, sp, 192);
            }
        }
        if (nearest == null) {
            state = new ScannerState(DepositScannerClientHandler.AntennaStatus.INACTIVE, 60, false);
        } else {
            state = DepositScannerServerHandler.getScannerState(sp, nearest);
            if (state.found) {
                depData.markAsFound(nearest);
            }
        }
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new DepositScannerS2CPayload(state.antennaStatus, state.interval, state.found, rt), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static ScannerState getScannerState(ServerPlayer sp, BlockPos targetPos) {
        BlockPos playerPos = sp.blockPosition();
        double distance = Math.min(3072.0, Math.sqrt(playerPos.distSqr((Vec3i)targetPos)));
        float curYaw = sp.getYRot();
        float targetYaw = DepositScannerServerHandler.getYaw(playerPos, targetPos);
        float diff = Mth.wrapDegrees((float)(targetYaw - curYaw));
        DepositScannerClientHandler.AntennaStatus status = Math.abs(diff) < 30.0f ? DepositScannerClientHandler.AntennaStatus.BOTH_ACTIVE : (diff <= 0.0f ? DepositScannerClientHandler.AntennaStatus.LEFT_ACTIVE : DepositScannerClientHandler.AntennaStatus.RIGHT_ACTIVE);
        int interval = 3 + (int)(57.0f * Utils.easeOut((float)distance / 3072.0f, 2.0f));
        boolean found = distance <= 5.0;
        return new ScannerState(status, interval, found);
    }

    private static float getYaw(BlockPos from, BlockPos to) {
        Vec3 a = Vec3.atCenterOf((Vec3i)from);
        Vec3 b = Vec3.atCenterOf((Vec3i)to);
        Vec3 v = b.subtract(a);
        return (float)Mth.wrapDegrees((double)Math.toDegrees(Mth.atan2((double)(-v.x), (double)v.z)));
    }

    public static enum RequestType {
        DISCOVER,
        TRACK;

    }

    private record ScannerState(DepositScannerClientHandler.AntennaStatus antennaStatus, int interval, boolean found) {
    }
}

