/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.mining.MiningBlockEntity;
import com.bmaster.createrns.mining.MiningBlockEntityInstanceHolder;
import com.simibubi.create.AllItems;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MiningAreaOutlineRenderer {
    private static final String OUTLINER_SLOT = "%s:miningAreaOutline".formatted("create_rns");
    private static final int MAX_TTL = 30;
    private static final int OUTLINE_MAX_DIST = 64;
    private static boolean outlineActive = false;
    private static boolean outlineChanged = true;
    private static final ObjectOpenHashSet<BlockPos> selectedCluster = new ObjectOpenHashSet();
    private static int ttl = 0;

    public static void clearAndAddNearbyMiningBEs() {
        if (!outlineActive) {
            return;
        }
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null) {
            return;
        }
        Level l = p.level();
        selectedCluster.clear();
        outlineChanged = true;
        MiningBlockEntityInstanceHolder.getInstancesWithinManhattanDistance(l, p.blockPosition(), 64).forEach(MiningAreaOutlineRenderer::addMiningBE);
    }

    public static void addMiningBE(MiningBlockEntity be) {
        if (!outlineActive) {
            return;
        }
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null) {
            return;
        }
        if (Math.sqrt(be.getBlockPos().distManhattan((Vec3i)p.blockPosition())) > 64.0) {
            return;
        }
        if (selectedCluster.addAll(be.reservedDepositBlocks)) {
            outlineChanged = true;
        }
    }

    public static void removeMiningBE(MiningBlockEntity be) {
        if (!outlineActive) {
            return;
        }
        LocalPlayer p = Minecraft.getInstance().player;
        if (p == null) {
            return;
        }
        if (Math.sqrt(be.getBlockPos().distManhattan((Vec3i)p.blockPosition())) > 64.0) {
            return;
        }
        if (selectedCluster.removeAll(be.reservedDepositBlocks)) {
            outlineChanged = true;
        }
    }

    public static void clearOutline() {
        outlineActive = false;
    }

    public static void tick() {
        MiningAreaOutlineRenderer.activateOutlineIfNeeded();
        if (!outlineActive) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer p = mc.player;
        if (p == null) {
            return;
        }
        ttl = MiningAreaOutlineRenderer.holdingCorrectItem((Player)p) ? 30 : --ttl;
        if (ttl <= 0) {
            outlineActive = false;
            return;
        }
        if (!selectedCluster.isEmpty()) {
            if (outlineChanged) {
                outlineChanged = false;
                Outliner.getInstance().showCluster((Object)OUTLINER_SLOT, selectedCluster);
            } else {
                Outliner.getInstance().keep((Object)OUTLINER_SLOT);
            }
        }
    }

    private static boolean holdingCorrectItem(Player p) {
        ItemStack mainHandItem = p.getMainHandItem();
        return AllItems.WRENCH.isIn(mainHandItem) || RNSContent.MINER_MK1_BLOCK.isIn(mainHandItem) || RNSContent.MINER_MK2_BLOCK.isIn(mainHandItem);
    }

    private static void activateOutlineIfNeeded() {
        BlockHitResult ray;
        boolean lookingAtMiningBE;
        if (outlineActive) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer p = mc.player;
        if (p == null) {
            return;
        }
        Level l = p.level();
        HitResult hitResult = mc.hitResult;
        boolean bl = lookingAtMiningBE = hitResult instanceof BlockHitResult && l.getBlockEntity((ray = (BlockHitResult)hitResult).getBlockPos()) instanceof MiningBlockEntity;
        if (MiningAreaOutlineRenderer.holdingCorrectItem((Player)p) && lookingAtMiningBE) {
            ttl = 30;
            outlineActive = true;
            MiningAreaOutlineRenderer.clearAndAddNearbyMiningBEs();
        }
    }
}

