/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.mining.MiningBlockEntity;
import com.bmaster.createrns.mining.MiningBlockEntityInstanceHolder;
import com.bmaster.createrns.mining.MiningEntityItemHandler;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class MiningBlock
extends KineticBlock {
    public MiningBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        super.onPlace(state, level, pos, oldState, isMoving);
        if (level.isClientSide || oldState.is(state.getBlock()) || !((blockEntity = level.getBlockEntity(pos)) instanceof MiningBlockEntity)) {
            return;
        }
        MiningBlockEntity be = (MiningBlockEntity)blockEntity;
        be.reserveDepositBlocks();
        be.notifyUpdate();
    }

    @ParametersAreNonnullByDefault
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        Set<MiningBlockEntity> nearbyMiningBEs = null;
        if (!state.is(newState.getBlock()) && (be = level.getBlockEntity(pos)) instanceof MiningBlockEntity) {
            MiningBlockEntity minerBE = (MiningBlockEntity)be;
            MiningEntityItemHandler minerInvCap = minerBE.getItemHandler(null);
            if (minerInvCap != null) {
                for (int i = 0; i < minerInvCap.getSlots(); ++i) {
                    ItemStack stack = minerInvCap.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
            }
            if (!level.isClientSide) {
                nearbyMiningBEs = MiningBlockEntityInstanceHolder.getInstancesWithIntersectingMiningArea(minerBE);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (nearbyMiningBEs != null) {
            for (MiningBlockEntity m : nearbyMiningBEs) {
                m.reserveDepositBlocks();
                m.notifyUpdate();
            }
        }
    }
}

