/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.RNSTags;
import com.bmaster.createrns.mining.MiningAreaOutlineRenderer;
import com.bmaster.createrns.mining.MiningBlockEntityInstanceHolder;
import com.bmaster.createrns.mining.MiningEntityItemHandler;
import com.bmaster.createrns.mining.MiningLevel;
import com.bmaster.createrns.mining.MiningProcess;
import com.bmaster.createrns.mining.MiningRecipeLookup;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MiningBlockEntity
extends KineticBlockEntity {
    public Set<BlockPos> reservedDepositBlocks = new HashSet<BlockPos>();
    protected MiningProcess process = null;
    protected final MiningEntityItemHandler inventory = new MiningEntityItemHandler(() -> {
        if (this.level != null && !this.level.isClientSide) {
            this.level.invalidateCapabilities(this.worldPosition);
            this.setChanged();
            this.notifyUpdate();
        }
    });
    private CompoundTag miningProgressTag = null;

    public MiningBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract int getMiningAreaRadius();

    public abstract int getMiningAreaDepth();

    public abstract int getMiningAreaYOffset();

    public abstract int getCurrentProgressIncrement();

    public abstract int getBaseProgress();

    public abstract boolean isMining();

    public abstract MiningLevel getMiningLevel();

    @Nullable
    public MiningEntityItemHandler getItemHandler(Direction side) {
        if (side == null || side == Direction.UP) {
            return this.inventory;
        }
        return null;
    }

    public BoundingBox getMiningArea(@NotNull Level l) {
        BlockPos pos = this.getBlockPos();
        int px = pos.getX();
        int py = pos.getY();
        int pz = pos.getZ();
        int minBuildHeight = l.getMinBuildHeight();
        int maxBuildHeight = l.getMaxBuildHeight();
        int mineRadius = this.getMiningAreaRadius();
        int yMin = Mth.clamp((int)(py + this.getMiningAreaYOffset() - this.getMiningAreaDepth() + 1), (int)minBuildHeight, (int)maxBuildHeight);
        int yMax = Mth.clamp((int)(py + this.getMiningAreaYOffset()), (int)minBuildHeight, (int)maxBuildHeight);
        return new BoundingBox(px - mineRadius, yMin, pz - mineRadius, px + mineRadius, yMax, pz + mineRadius);
    }

    public void reserveDepositBlocks() {
        if (this.level == null) {
            return;
        }
        MiningLevel ml = this.getMiningLevel();
        this.reservedDepositBlocks = this.getDepositVein().stream().filter(pos -> MiningRecipeLookup.isDepositMineable(this.level, this.level.getBlockState(pos).getBlock(), ml)).collect(Collectors.toSet());
        for (MiningBlockEntity m : MiningBlockEntityInstanceHolder.getInstancesWithIntersectingMiningArea(this)) {
            this.reservedDepositBlocks.removeAll(m.reservedDepositBlocks);
        }
        if (this.process != null && this.level != null) {
            this.process.setYields(this.level, this.reservedDepositBlocks, this.getBaseProgress());
        }
        this.setChanged();
    }

    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.process == null) {
            this.process = new MiningProcess(this.level, this.getMiningLevel(), this.reservedDepositBlocks, this.getBaseProgress());
            if (this.miningProgressTag != null) {
                this.process.setProgressFromNBT(this.miningProgressTag);
                this.miningProgressTag = null;
            }
        }
        if (this.isMining() && !this.level.isClientSide) {
            this.process.advance(this.getCurrentProgressIncrement());
            this.inventory.collectMinedItems(this.process);
        }
    }

    public void onLoad() {
        super.onLoad();
        MiningBlockEntityInstanceHolder.addInstance(this);
    }

    public void invalidate() {
        super.invalidate();
        MiningBlockEntityInstanceHolder.removeInstance(this);
        if (this.level == null) {
            return;
        }
        this.level.invalidateCapabilities(this.worldPosition);
        if (this.level.isClientSide()) {
            MiningAreaOutlineRenderer.removeMiningBE(this);
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider p, boolean clientPacket) {
        super.write(tag, p, clientPacket);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(p));
        long[] packed = this.reservedDepositBlocks.stream().mapToLong(BlockPos::asLong).toArray();
        tag.putLongArray("ReservedDepositBlocks", packed);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider p, boolean clientPacket) {
        long[] packed;
        super.read(tag, p, clientPacket);
        if (clientPacket) {
            CreateRNS.LOGGER.trace("Client mining BE synced at {}, {}", (Object)this.worldPosition.getX(), (Object)this.worldPosition.getZ());
        }
        this.inventory.deserializeNBT(p, tag.getCompound("Inventory"));
        if (clientPacket) {
            MiningAreaOutlineRenderer.removeMiningBE(this);
        }
        this.reservedDepositBlocks.clear();
        for (long l : packed = tag.getLongArray("ReservedDepositBlocks")) {
            this.reservedDepositBlocks.add(BlockPos.of((long)l));
        }
        if (clientPacket) {
            MiningAreaOutlineRenderer.addMiningBE(this);
        }
        if (this.process != null && this.level != null) {
            this.process.setYields(this.level, this.reservedDepositBlocks, this.getBaseProgress());
        }
    }

    private Set<BlockPos> getDepositVein() {
        if (this.level == null) {
            return Set.of();
        }
        TagKey<Block> depTag = RNSTags.Block.DEPOSIT_BLOCKS;
        BoundingBox ma = this.getMiningArea(this.level);
        ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
        LongOpenHashSet visited = new LongOpenHashSet(ma.getXSpan() * ma.getYSpan() * ma.getZSpan());
        q.offer(this.worldPosition.relative(Direction.Axis.Y, this.getMiningAreaYOffset()));
        while (!q.isEmpty()) {
            BlockPos bp = (BlockPos)q.poll();
            if (visited.contains(bp.asLong()) || !ma.isInside((Vec3i)bp) || !this.level.getBlockState(bp).is(depTag)) continue;
            visited.add(bp.asLong());
            Direction.stream().forEach(d -> q.add(bp.relative(d)));
        }
        return visited.longStream().mapToObj(BlockPos::of).collect(Collectors.toSet());
    }
}

