/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.mining.MiningProcess;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MiningEntityItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    private static final int MAX_COUNT_PER_TYPE = 64;
    private List<Item> types;
    private final Object2ObjectOpenHashMap<Item, ItemStack> typeToStack;
    private final Runnable onContentsChangedRunnable;

    public MiningEntityItemHandler(Runnable onContentsChanged) {
        this.types = new ArrayList<Item>();
        this.typeToStack = new Object2ObjectOpenHashMap();
        this.onContentsChangedRunnable = onContentsChanged;
    }

    public MiningEntityItemHandler(List<Item> slotTypes, Runnable onContentsChanged) {
        this.types = new ArrayList<Item>(slotTypes);
        this.typeToStack = slotTypes.stream().collect(Collectors.toMap(i -> i, i -> ItemStack.EMPTY, (o, n) -> n, () -> new Object2ObjectOpenHashMap(slotTypes.size())));
        this.onContentsChangedRunnable = onContentsChanged;
    }

    public boolean isEmpty() {
        return this.typeToStack.values().stream().allMatch(ItemStack::isEmpty);
    }

    public int getSlots() {
        return this.typeToStack.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack stack = (ItemStack)this.typeToStack.get((Object)this.types.get(slot));
        return stack.getCount() > 0 ? stack.copy() : ItemStack.EMPTY;
    }

    public void collectMinedItems(MiningProcess process) {
        if (process == null) {
            return;
        }
        boolean invUpdated = false;
        for (ItemStack minedStack : process.collect()) {
            ItemStack existingStack;
            Item minedType = minedStack.getItem();
            int minedCount = minedStack.getCount();
            if (this.typeToStack.containsKey((Object)minedType)) {
                existingStack = (ItemStack)this.typeToStack.get((Object)minedType);
                int existingCount = existingStack.getCount();
                int updatedCount = Math.min(64, existingCount + minedCount);
                existingStack.setCount(updatedCount);
                invUpdated = updatedCount != existingCount;
            } else {
                existingStack = minedStack;
                existingStack.setCount(Math.min(64, minedCount));
                this.types.addFirst(minedType);
                this.typeToStack.put((Object)minedType, (Object)minedStack);
                invUpdated = true;
            }
            if (invUpdated) {
                CreateRNS.LOGGER.trace("Mined {}", (Object)existingStack.getItem());
                continue;
            }
            CreateRNS.LOGGER.trace("Could not mine {}", (Object)existingStack.getItem());
        }
        if (invUpdated) {
            this.onContentsChanged();
        }
    }

    @NotNull
    public ItemStack extractFirstAvailableItem(boolean simulate) {
        for (Map.Entry e : this.typeToStack.entrySet()) {
            ItemStack stack = (ItemStack)e.getValue();
            if (stack.isEmpty()) continue;
            ItemStack newStack = stack.copyWithCount(1);
            if (!simulate) {
                stack.shrink(1);
                this.onContentsChanged();
            }
            return newStack;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack newStack;
        if (slot >= this.types.size()) {
            return ItemStack.EMPTY;
        }
        Item type = this.types.get(slot);
        ItemStack existingStack = (ItemStack)this.typeToStack.get((Object)type);
        int existingStackCount = existingStack.getCount();
        int extractedCount = Math.min(amount, existingStackCount);
        int updatedCount = existingStackCount - extractedCount;
        if (!simulate && updatedCount != existingStackCount) {
            newStack = existingStack.copyWithCount(extractedCount);
            if (updatedCount > 0) {
                existingStack.setCount(updatedCount);
            } else {
                this.types.remove(type);
                this.typeToStack.remove((Object)type);
            }
            this.onContentsChanged();
        } else {
            newStack = ItemStack.EMPTY;
        }
        return newStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, boolean simulate) {
        return this.extractItem(slot, 64, simulate);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return false;
    }

    private void onContentsChanged() {
        this.onContentsChangedRunnable.run();
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider p) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.types.size(); ++i) {
            Item type = this.types.get(i);
            ItemStack stack = (ItemStack)this.typeToStack.get((Object)type);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            itemTag.put("Item", stack.save(p));
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider p, CompoundTag nbt) {
        this.typeToStack.clear();
        ListTag tagList = nbt.getList("Items", 10);
        List<CompoundTag> tags = IntStream.range(0, tagList.size()).mapToObj(arg_0 -> ((ListTag)tagList).getCompound(arg_0)).toList();
        this.types = new ArrayList<Item>(tags.size());
        for (CompoundTag t : tags) {
            int slot = t.getInt("Slot");
            if (0 > slot || slot >= tags.size()) continue;
            ItemStack newStack = ItemStack.parseOptional((HolderLookup.Provider)p, (CompoundTag)t.getCompound("Item"));
            Item newType = newStack.getItem();
            this.types.add(slot, newType);
            this.typeToStack.put((Object)newType, (Object)newStack);
        }
    }
}

