/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining.miner;

import com.bmaster.createrns.mining.MiningBlockEntity;
import com.bmaster.createrns.mining.MiningProcess;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Comparator;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class MinerBlockEntity
extends MiningBlockEntity {
    private List<BlockState> particleOptions = null;

    public MinerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getCurrentProgressIncrement() {
        return (int)Math.abs(this.getSpeed());
    }

    @Override
    public boolean isMining() {
        if (this.level == null || this.process == null) {
            return false;
        }
        return !this.reservedDepositBlocks.isEmpty() && this.isSpeedRequirementFulfilled();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            if (this.isMining()) {
                this.spawnParticles();
            }
        } else {
            this.tryEjectUp();
        }
    }

    public void tickAudio() {
        if (!this.isMining()) {
            return;
        }
        float speed = Math.abs(this.getSpeed());
        float pitch = Mth.clamp((float)(speed / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.CRUSHING, (BlockPos)this.worldPosition, (float)pitch);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = false;
        added = !isPlayerSneaking ? this.addInventoryToGoggleTooltip(tooltip, true) : this.addRatesToGoggleTooltip(tooltip, true);
        if (!added) {
            added = !isPlayerSneaking ? this.addRatesToGoggleTooltip(tooltip, true) : this.addInventoryToGoggleTooltip(tooltip, true);
        }
        added = this.addKineticsToGoggleTooltip(tooltip, !added);
        return added;
    }

    protected void tryEjectUp() {
        if (this.level == null) {
            return;
        }
        BlockPos above = this.worldPosition.above();
        IItemHandler targetInv = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, above, (Object)Direction.DOWN);
        if (targetInv == null) {
            InvManipulationBehaviour inserter = this.level.getBlockEntity(above) == null ? null : (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)above, (BehaviourType)InvManipulationBehaviour.TYPE);
            IItemHandler iItemHandler = targetInv = inserter == null ? null : (IItemHandler)inserter.getInventory();
        }
        if (targetInv == null) {
            return;
        }
        ItemStack extracted = this.inventory.extractFirstAvailableItem(true);
        if (extracted.isEmpty()) {
            return;
        }
        for (int i = 0; i < targetInv.getSlots(); ++i) {
            ItemStack remaining = targetInv.insertItem(i, extracted, true);
            if (!remaining.isEmpty()) continue;
            extracted = this.inventory.extractFirstAvailableItem(false);
            assert (!extracted.isEmpty());
            remaining = targetInv.insertItem(i, extracted, false);
            assert (remaining.isEmpty());
            return;
        }
    }

    protected void addStressImpactStats(List<Component> tooltip, float stressAtBase) {
        super.addStressImpactStats(tooltip, stressAtBase);
    }

    protected boolean addInventoryToGoggleTooltip(List<Component> tooltip, boolean isMainSection) {
        if (this.inventory.isEmpty()) {
            return false;
        }
        if (isMainSection) {
            new LangBuilder("create_rns").translate("miner.contents", new Object[0]).forGoggles(tooltip);
        } else {
            new LangBuilder("create_rns").space().forGoggles(tooltip);
        }
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack is = this.inventory.getStackInSlot(slot);
            if (is.equals(ItemStack.EMPTY)) continue;
            new LangBuilder("create_rns").add(is.getHoverName().copy().withStyle(ChatFormatting.GRAY)).add(Component.literal((String)(" x" + is.getCount())).withStyle(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected boolean addRatesToGoggleTooltip(List<Component> tooltip, boolean isMainSection) {
        if (this.process == null || this.reservedDepositBlocks.isEmpty()) {
            return false;
        }
        if (isMainSection) {
            new LangBuilder("create_rns").translate("miner.production_rates", new Object[0]).forGoggles(tooltip);
        } else {
            new LangBuilder("create_rns").space().forGoggles(tooltip);
        }
        List<MiningProcess.SingleTypeProcess> stpListSorted = this.process.innerProcesses.stream().sorted(Comparator.comparingInt(p -> p.maxProgress)).toList();
        for (MiningProcess.SingleTypeProcess p2 : stpListSorted) {
            int progressPerHour = 72000 * this.getCurrentProgressIncrement();
            float itemsPerHour = (float)((long)progressPerHour * 10L / (long)p2.maxProgress) / 10.0f;
            new LangBuilder("create_rns").add(p2.yield.getDescription().copy().append(": ").withStyle(ChatFormatting.GRAY)).add(Component.literal((String)Float.toString(itemsPerHour)).append((Component)Component.translatable((String)"%s.miner.per_hour".formatted("create_rns"))).withStyle(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected boolean addKineticsToGoggleTooltip(List<Component> tooltip, boolean isMainSection) {
        float stressAtBase = 0.0f;
        if (IRotate.StressImpact.isEnabled()) {
            stressAtBase = this.calculateStressApplied();
        }
        if (Mth.equal((float)stressAtBase, (float)0.0f)) {
            return false;
        }
        if (isMainSection) {
            CreateLang.translate((String)"gui.goggles.kinetic_stats", (Object[])new Object[0]).forGoggles(tooltip);
        } else {
            new LangBuilder("create_rns").space().forGoggles(tooltip);
        }
        this.addStressImpactStats(tooltip, this.calculateStressApplied());
        return true;
    }

    protected void spawnParticles() {
        if (this.level == null) {
            return;
        }
        if (this.particleOptions == null) {
            this.particleOptions = this.reservedDepositBlocks.stream().map(bp -> this.level.getBlockState(bp)).toList();
        }
        RandomSource r = this.level.random;
        BlockState selectedParticle = this.particleOptions.get(r.nextInt(0, this.particleOptions.size()));
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.BLOCK, selectedParticle);
        for (int i = 0; i < 2; ++i) {
            this.level.addParticle((ParticleOptions)particleData, (double)((float)this.worldPosition.getX() + r.nextFloat()), (double)this.worldPosition.getY() - 0.5 + (double)r.nextFloat(), (double)((float)this.worldPosition.getZ() + r.nextFloat()), 0.0, 0.0, 0.0);
        }
    }
}

