/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.RNSTags;
import com.bmaster.createrns.deposit.DepositBlock;
import com.bmaster.createrns.deposit.LevelDepositData;
import com.bmaster.createrns.item.DepositScanner.DepositScannerItem;
import com.bmaster.createrns.mining.miner.impl.MinerMk1Block;
import com.bmaster.createrns.mining.miner.impl.MinerMk1BlockEntity;
import com.bmaster.createrns.mining.miner.impl.MinerMk1Renderer;
import com.bmaster.createrns.mining.miner.impl.MinerMk1Visual;
import com.bmaster.createrns.mining.miner.impl.MinerMk2Block;
import com.bmaster.createrns.mining.miner.impl.MinerMk2BlockEntity;
import com.bmaster.createrns.mining.miner.impl.MinerMk2Renderer;
import com.bmaster.createrns.mining.miner.impl.MinerMk2Visual;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Supplier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class RNSContent {
    public static final PartialModel MINER_MK1_DRILL = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"block/miner_mk1/drill_head"));
    public static final PartialModel MINER_MK2_DRILL = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"block/miner_mk2/drill_head"));
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES;
    public static final Supplier<AttachmentType<LevelDepositData>> LEVEL_DEPOSIT_DATA;
    public static final RegistryEntry<CreativeModeTab, CreativeModeTab> MAIN_TAB;
    public static final ItemEntry<DepositScannerItem> DEPOSIT_SCANNER_ITEM;
    public static final ItemEntry<Item> RESONANT_MECHANISM;
    public static final ItemEntry<Item> IMPURE_IRON_ORE;
    public static final ItemEntry<Item> IMPURE_COPPER_ORE;
    public static final ItemEntry<Item> IMPURE_ZINC_ORE;
    public static final ItemEntry<Item> IMPURE_GOLD_ORE;
    public static final ItemEntry<Item> IMPURE_REDSTONE_DUST;
    public static final ItemEntry<Item> REDSTONE_SMALL_DUST;
    public static final BlockEntry<MinerMk1Block> MINER_MK1_BLOCK;
    public static final BlockEntry<MinerMk2Block> MINER_MK2_BLOCK;
    public static final BlockEntry<DepositBlock> IRON_DEPOSIT_BLOCK;
    public static final BlockEntry<DepositBlock> COPPER_DEPOSIT_BLOCK;
    public static final BlockEntry<DepositBlock> ZINC_DEPOSIT_BLOCK;
    public static final BlockEntry<DepositBlock> GOLD_DEPOSIT_BLOCK;
    public static final BlockEntry<DepositBlock> REDSTONE_DEPOSIT_BLOCK;
    public static final BlockEntityEntry<MinerMk1BlockEntity> MINER_MK1_BE;
    public static final BlockEntityEntry<MinerMk2BlockEntity> MINER_MK2_BE;

    public static void register(IEventBus modBus) {
        ATTACHMENT_TYPES.register(modBus);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> deposit(MapColor mapColor) {
        return b -> (BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.RAW_IRON_BLOCK).properties(p -> p.mapColor(mapColor).strength(50.0f, 1200.0f).pushReaction(PushReaction.BLOCK).noLootTable()).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_DIAMOND_TOOL}).tag(new TagKey[]{RNSTags.Block.DEPOSIT_BLOCKS}).item().tag(new TagKey[]{RNSTags.Item.DEPOSIT_BLOCKS}).build();
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> minerBlockCommon() {
        return builder -> ((BlockBuilder)builder.initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.PODZOL).pushReaction(PushReaction.BLOCK)).transform(TagGen.axeOrPickaxe())).blockstate((c, p) -> p.simpleBlock((Block)c.get(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0])));
    }

    static {
        CreateRNS.REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"create_rns");
        LEVEL_DEPOSIT_DATA = ATTACHMENT_TYPES.register("level_deposit_data", () -> AttachmentType.serializable(LevelDepositData::new).build());
        MAIN_TAB = CreateRNS.REGISTRATE.defaultCreativeTab("create_rns", c -> c.icon(() -> MINER_MK2_BLOCK.asStack()).title((Component)Component.translatable((String)"creativetab.%s".formatted("create_rns"))).build()).register();
        DEPOSIT_SCANNER_ITEM = CreateRNS.REGISTRATE.item("deposit_scanner", DepositScannerItem::new).properties(p -> p.stacksTo(1)).model(AssetLookup.itemModelWithPartials()).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get())).define(Character.valueOf('E'), (ItemLike)AllItems.ELECTRON_TUBE).define(Character.valueOf('W'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('C'), (ItemLike)AllBlocks.ANDESITE_CASING).define(Character.valueOf('T'), (ItemLike)AllItems.TRANSMITTER).pattern(" E ").pattern("TWT").pattern(" C ").unlockedBy("has_electron_tube", RegistrateRecipeProvider.has((ItemLike)AllItems.ELECTRON_TUBE)).save((RecipeOutput)p)).register();
        RESONANT_MECHANISM = CreateRNS.REGISTRATE.item("resonant_mechanism", Item::new).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get())).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('M'), (ItemLike)AllItems.PRECISION_MECHANISM).pattern(" A ").pattern("AMA").pattern(" A ").unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)AllItems.PRECISION_MECHANISM)).save((RecipeOutput)p)).register();
        IMPURE_IRON_ORE = CreateRNS.REGISTRATE.item("impure_iron_ore", Item::new).tag(new TagKey[]{RNSTags.Item.IMPURE_ORES}).register();
        IMPURE_COPPER_ORE = CreateRNS.REGISTRATE.item("impure_copper_ore", Item::new).tag(new TagKey[]{RNSTags.Item.IMPURE_ORES}).register();
        IMPURE_ZINC_ORE = CreateRNS.REGISTRATE.item("impure_zinc_ore", Item::new).tag(new TagKey[]{RNSTags.Item.IMPURE_ORES}).register();
        IMPURE_GOLD_ORE = CreateRNS.REGISTRATE.item("impure_gold_ore", Item::new).tag(new TagKey[]{RNSTags.Item.IMPURE_ORES}).register();
        IMPURE_REDSTONE_DUST = CreateRNS.REGISTRATE.item("impure_redstone_dust", Item::new).tag(new TagKey[]{RNSTags.Item.IMPURE_ORES}).register();
        REDSTONE_SMALL_DUST = CreateRNS.REGISTRATE.item("redstone_small_dust", Item::new).register();
        MINER_MK1_BLOCK = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateRNS.REGISTRATE.block("miner_mk1", MinerMk1Block::new).transform(RNSContent.minerBlockCommon())).onRegister(b -> BlockStressValues.IMPACTS.register((Object)b, () -> 2.0))).item().model(AssetLookup::customItemModel).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get())).define(Character.valueOf('F'), (ItemLike)AllBlocks.ANDESITE_FUNNEL).define(Character.valueOf('C'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('D'), (ItemLike)AllBlocks.MECHANICAL_DRILL).pattern("F").pattern("C").pattern("D").unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)AllBlocks.MECHANICAL_DRILL)).save((RecipeOutput)p)).build()).register();
        MINER_MK2_BLOCK = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateRNS.REGISTRATE.block("miner_mk2", MinerMk2Block::new).transform(RNSContent.minerBlockCommon())).onRegister(b -> BlockStressValues.IMPACTS.register((Object)b, () -> 2.0))).item().model(AssetLookup::customItemModel).recipe((c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get())).define(Character.valueOf('F'), (ItemLike)AllBlocks.BRASS_FUNNEL).define(Character.valueOf('R'), RESONANT_MECHANISM).define(Character.valueOf('M'), MINER_MK1_BLOCK).pattern("F").pattern("R").pattern("M").unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)AllItems.PRECISION_MECHANISM)).save((RecipeOutput)p)).build()).register();
        IRON_DEPOSIT_BLOCK = ((BlockBuilder)CreateRNS.REGISTRATE.block("iron_deposit_block", DepositBlock::new).transform(RNSContent.deposit(MapColor.RAW_IRON))).register();
        COPPER_DEPOSIT_BLOCK = ((BlockBuilder)CreateRNS.REGISTRATE.block("copper_deposit_block", DepositBlock::new).transform(RNSContent.deposit(MapColor.COLOR_ORANGE))).register();
        ZINC_DEPOSIT_BLOCK = ((BlockBuilder)CreateRNS.REGISTRATE.block("zinc_deposit_block", DepositBlock::new).transform(RNSContent.deposit(MapColor.GLOW_LICHEN))).register();
        GOLD_DEPOSIT_BLOCK = ((BlockBuilder)CreateRNS.REGISTRATE.block("gold_deposit_block", DepositBlock::new).transform(RNSContent.deposit(MapColor.GOLD))).register();
        REDSTONE_DEPOSIT_BLOCK = ((BlockBuilder)CreateRNS.REGISTRATE.block("redstone_deposit_block", DepositBlock::new).transform(RNSContent.deposit(MapColor.FIRE))).register();
        MINER_MK1_BE = CreateRNS.REGISTRATE.blockEntity("miner_mk1", (t, p, s) -> new MinerMk1BlockEntity(t, p, s)).visual(() -> MinerMk1Visual::new).validBlock(MINER_MK1_BLOCK).renderer(() -> MinerMk1Renderer::new).register();
        MINER_MK2_BE = CreateRNS.REGISTRATE.blockEntity("miner_mk2", (t, p, s) -> new MinerMk2BlockEntity(t, p, s)).visual(() -> MinerMk2Visual::new).validBlock(MINER_MK2_BLOCK).renderer(() -> MinerMk2Renderer::new).register();
    }
}

