/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.compat.jei;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.RNSRecipeTypes;
import com.bmaster.createrns.compat.jei.AdvancedMiningRecipeCategory;
import com.bmaster.createrns.compat.jei.BasicMiningRecipeCategory;
import com.bmaster.createrns.mining.miner.impl.MinerMk1Block;
import com.bmaster.createrns.mining.miner.impl.MinerMk2Block;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class RNSJEI
implements IModPlugin {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new BasicMiningRecipeCategory()});
        reg.addRecipeCategories(new IRecipeCategory[]{new AdvancedMiningRecipeCategory()});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        List basicRecipes = level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RNSRecipeTypes.BASIC_MINING_TYPE.get());
        List advancedRecipes = level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RNSRecipeTypes.ADVANCED_MINING_TYPE.get());
        reg.addRecipes(BasicMiningRecipeCategory.JEI_RECIPE_TYPE, basicRecipes);
        reg.addRecipes(AdvancedMiningRecipeCategory.JEI_RECIPE_TYPE, advancedRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)((MinerMk1Block)((Object)RNSContent.MINER_MK1_BLOCK.get())).asItem()), new RecipeType[]{BasicMiningRecipeCategory.JEI_RECIPE_TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)((MinerMk2Block)((Object)RNSContent.MINER_MK2_BLOCK.get())).asItem()), new RecipeType[]{AdvancedMiningRecipeCategory.JEI_RECIPE_TYPE});
    }
}

