/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.deposit;

import com.bmaster.createrns.mining.MiningBlockEntity;
import com.bmaster.createrns.mining.MiningBlockEntityInstanceHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class DepositBlock
extends Block {
    public DepositBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @ParametersAreNonnullByDefault
    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (level.isClientSide) {
            return;
        }
        for (MiningBlockEntity m : MiningBlockEntityInstanceHolder.getInstancesThatCouldMine(level, pos)) {
            m.reserveDepositBlocks();
            BlockPos mPos = m.getBlockPos();
            BlockState mState = level.getBlockState(mPos);
            level.sendBlockUpdated(mPos, mState, mState, 2);
        }
    }

    @ParametersAreNonnullByDefault
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (level.isClientSide) {
            return;
        }
        for (MiningBlockEntity m : MiningBlockEntityInstanceHolder.getInstancesThatCouldMine(level, pos)) {
            m.reserveDepositBlocks();
            BlockPos mPos = m.getBlockPos();
            BlockState mState = level.getBlockState(mPos);
            level.sendBlockUpdated(mPos, mState, mState, 2);
        }
    }
}

