/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.deposit;

import com.bmaster.createrns.CreateRNS;
import com.bmaster.createrns.util.Utils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ParametersAreNonnullByDefault
public class LevelDepositData
implements INBTSerializable<CompoundTag> {
    public static final int MIN_COMPUTE_INTERVAL = 90;
    private final ObjectOpenHashSet<BlockPos> generatedFoundDeposits = new ObjectOpenHashSet();
    private final Object2ObjectOpenHashMap<ResourceLocation, ObjectOpenHashSet<BlockPos>> generatedDeposits = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceLocation, ObjectOpenHashSet<BlockPos>> ungeneratedDeposits = new Object2ObjectOpenHashMap();
    private final Cache<UUID, CachedData> perPlayerCache = CacheBuilder.newBuilder().initialCapacity(1).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    @Nullable
    public BlockPos getNearest(ResourceKey<Structure> depositKey, ServerPlayer sp, int searchRadiusChunks) {
        double dist;
        Level sl = sp.level();
        CachedData hit = (CachedData)this.perPlayerCache.getIfPresent((Object)sp.getUUID());
        if (hit != null && sl.getGameTime() - hit.creationTimestamp < 90L) {
            return null;
        }
        BlockPos playerPos = sp.blockPosition();
        BlockPos closestBP = null;
        double closestDist = Double.MAX_VALUE;
        for (BlockPos d : (ObjectOpenHashSet)this.generatedDeposits.getOrDefault((Object)depositKey.location(), (Object)new ObjectOpenHashSet())) {
            dist = playerPos.distSqr((Vec3i)d);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestBP = new BlockPos((Vec3i)d);
        }
        for (BlockPos d : (ObjectOpenHashSet)this.ungeneratedDeposits.getOrDefault((Object)depositKey.location(), (Object)new ObjectOpenHashSet())) {
            dist = playerPos.distSqr((Vec3i)d);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestBP = new BlockPos((Vec3i)d);
        }
        BlockPos closestUnknownBP = this.discoverNearest(depositKey, sp, searchRadiusChunks);
        if (closestUnknownBP != null && playerPos.distSqr((Vec3i)closestUnknownBP) < closestDist) {
            closestBP = closestUnknownBP;
        }
        if (closestBP == null) {
            this.perPlayerCache.put((Object)sp.getUUID(), (Object)new CachedData(null, depositKey, sl.getGameTime()));
            CreateRNS.LOGGER.debug("No deposits of target type are recorded");
            return null;
        }
        if (this.isOutsideSearchRadius(playerPos, closestBP, searchRadiusChunks)) {
            this.perPlayerCache.put((Object)sp.getUUID(), (Object)new CachedData(closestBP.asLong(), depositKey, sl.getGameTime()));
            CreateRNS.LOGGER.debug("No deposits in scanned area. Closest is at {},{} ({} blocks away)", new Object[]{closestBP.getX(), closestBP.getZ(), (int)Math.sqrt(closestDist)});
            return null;
        }
        this.perPlayerCache.put((Object)sp.getUUID(), (Object)new CachedData(closestBP.asLong(), depositKey, sl.getGameTime()));
        CreateRNS.LOGGER.debug("Found deposit at {},{}", (Object)closestBP.getX(), (Object)closestBP.getZ());
        return closestBP;
    }

    @Nullable
    public BlockPos getNearestCached(ResourceKey<Structure> depositKey, ServerPlayer sp, int searchRadiusChunks) {
        CachedData hit = (CachedData)this.perPlayerCache.getIfPresent((Object)sp.getUUID());
        if (hit == null) {
            CreateRNS.LOGGER.trace("[Cache miss] Deposit position is not cached for player");
            return null;
        }
        if (hit.dPosPacked == null) {
            CreateRNS.LOGGER.trace("[Cache hit] Deposit position in cache is null");
            return null;
        }
        BlockPos cachedBP = BlockPos.of((long)hit.dPosPacked);
        if (!hit.depositKey.equals(depositKey)) {
            CreateRNS.LOGGER.trace("[Cache hit] Found deposit at {},{}, but its type does not match the requested type", (Object)cachedBP.getX(), (Object)cachedBP.getZ());
        }
        if (this.isOutsideSearchRadius(sp.blockPosition(), cachedBP, searchRadiusChunks)) {
            CreateRNS.LOGGER.trace("[Cache hit] Found deposit at {},{}, but it's too far away", (Object)cachedBP.getX(), (Object)cachedBP.getZ());
            return null;
        }
        CreateRNS.LOGGER.trace("[Cache hit] Found deposit at {},{}", (Object)cachedBP.getX(), (Object)cachedBP.getZ());
        return cachedBP;
    }

    public void add(ResourceKey<Structure> depositKey, StructureStart ss, ServerLevel sl) {
        ChunkPos startChunk = ss.getChunkPos();
        if (!ss.isValid()) {
            CreateRNS.LOGGER.error("Attempted to add an invalid deposit start to level data");
            return;
        }
        BlockPos center = ss.getBoundingBox().getCenter();
        for (Object2ObjectMap.Entry t : this.ungeneratedDeposits.object2ObjectEntrySet()) {
            ObjectOpenHashSet dSet = (ObjectOpenHashSet)t.getValue();
            boolean removed = dSet.removeIf(d -> Utils.isPosInChunk(d, startChunk));
            if (!removed) continue;
            this.perPlayerCache.asMap().replaceAll((u, d) -> {
                if (d == null) {
                    return null;
                }
                if (d.dPosPacked == null || !Utils.isPosInChunk(BlockPos.of((long)d.dPosPacked), startChunk)) {
                    return d;
                }
                return new CachedData(center.asLong(), d.depositKey, d.creationTimestamp);
            });
            CreateRNS.LOGGER.debug("Generated deposit start at {},{} removed from ungenerated", (Object)startChunk.getBlockX(8), (Object)startChunk.getBlockZ(8));
        }
        if (this.generatedFoundDeposits.contains((Object)center)) {
            return;
        }
        ((ObjectOpenHashSet)this.generatedDeposits.computeIfAbsent((Object)depositKey.location(), k -> new ObjectOpenHashSet())).add((Object)center);
    }

    public void markAsFound(BlockPos centerPos) {
        Set foundGenSet = null;
        for (Object2ObjectMap.Entry e2 : this.generatedDeposits.object2ObjectEntrySet()) {
            ObjectOpenHashSet genSet = (ObjectOpenHashSet)e2.getValue();
            if (!genSet.contains((Object)centerPos)) continue;
            foundGenSet = genSet;
        }
        if (foundGenSet == null) {
            CreateRNS.LOGGER.error("Attempted to mark a non-existent deposit");
            return;
        }
        this.perPlayerCache.asMap().entrySet().removeIf(e -> {
            CachedData d = (CachedData)e.getValue();
            return d != null && d.dPosPacked != null && d.dPosPacked.longValue() == centerPos.asLong();
        });
        foundGenSet.remove(centerPos);
        this.generatedFoundDeposits.add((Object)centerPos);
        CreateRNS.LOGGER.debug("Marking {},{},{} as found", new Object[]{centerPos.getX(), centerPos.getY(), centerPos.getZ()});
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        long[] packed;
        ResourceLocation rl;
        CompoundTag root = new CompoundTag();
        CompoundTag generated = new CompoundTag();
        CompoundTag ungenerated = new CompoundTag();
        CreateRNS.LOGGER.trace("Serializing GeneratedFound {}", this.generatedFoundDeposits);
        CreateRNS.LOGGER.trace("Serializing Generated {}", this.generatedDeposits);
        CreateRNS.LOGGER.trace("Serializing Ungenerated {}", this.ungeneratedDeposits);
        long[] generatedFound = this.generatedFoundDeposits.stream().mapToLong(BlockPos::asLong).toArray();
        for (Object2ObjectMap.Entry e : this.generatedDeposits.object2ObjectEntrySet()) {
            rl = (ResourceLocation)e.getKey();
            packed = ((ObjectOpenHashSet)e.getValue()).stream().mapToLong(BlockPos::asLong).toArray();
            generated.putLongArray(rl.toString(), packed);
        }
        for (Object2ObjectMap.Entry e : this.ungeneratedDeposits.object2ObjectEntrySet()) {
            rl = (ResourceLocation)e.getKey();
            packed = ((ObjectOpenHashSet)e.getValue()).stream().mapToLong(BlockPos::asLong).toArray();
            ungenerated.putLongArray(rl.toString(), packed);
        }
        root.putLongArray("GeneratedFound", generatedFound);
        root.put("Generated", (Tag)generated);
        root.put("Ungenerated", (Tag)ungenerated);
        CreateRNS.LOGGER.trace("Serialized level deposit data with {}", (Object)root);
        return root;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        ObjectOpenHashSet set;
        CompoundTag generated;
        LongArrayTag generatedFound;
        Object object;
        block8: {
            block7: {
                object = nbt.get("GeneratedFound");
                if (!(object instanceof LongArrayTag)) break block7;
                generatedFound = (LongArrayTag)object;
                object = nbt.get("Generated");
                if (!(object instanceof CompoundTag)) break block7;
                generated = (CompoundTag)object;
                object = nbt.get("Ungenerated");
                if (object instanceof CompoundTag) break block8;
            }
            CreateRNS.LOGGER.error("Failed to deserialize level deposit data from nbt");
            return;
        }
        CompoundTag ungenerated = (CompoundTag)object;
        CreateRNS.LOGGER.trace("Deserializing level deposit data with tag {}", (Object)nbt);
        this.generatedFoundDeposits.clear();
        this.generatedDeposits.clear();
        this.ungeneratedDeposits.clear();
        for (Tag l : (Object)generatedFound.getAsLongArray()) {
            this.generatedFoundDeposits.add((Object)BlockPos.of((long)l));
        }
        for (String key : generated.getAllKeys()) {
            ResourceLocation rl = ResourceLocation.parse((String)key);
            long[] packed = generated.getLongArray(key);
            set = new ObjectOpenHashSet(packed.length);
            for (long l : packed) {
                set.add((Object)BlockPos.of((long)l));
            }
            this.generatedDeposits.put((Object)rl, (Object)set);
        }
        for (String key : ungenerated.getAllKeys()) {
            ResourceLocation rl = ResourceLocation.parse((String)key);
            long[] packed = ungenerated.getLongArray(key);
            set = new ObjectOpenHashSet(packed.length);
            for (long l : packed) {
                set.add((Object)BlockPos.of((long)l));
            }
            this.ungeneratedDeposits.put((Object)rl, (Object)set);
        }
        CreateRNS.LOGGER.trace("Deserialized GeneratedFound to {}", this.generatedFoundDeposits);
        CreateRNS.LOGGER.trace("Deserialized Generated to {}", this.generatedDeposits);
        CreateRNS.LOGGER.trace("Deserialized Ungenerated to {}", this.ungeneratedDeposits);
    }

    @Nullable
    private BlockPos discoverNearest(ResourceKey<Structure> depositKey, ServerPlayer sp, int searchRadiusChunks) {
        StructureStart ss;
        ServerLevel sl = (ServerLevel)sp.level();
        ChunkGenerator gen = sl.getChunkSource().getGenerator();
        Holder.Reference target = sl.registryAccess().registryOrThrow(Registries.STRUCTURE).getHolderOrThrow(depositKey);
        int searchRadiusRegions = searchRadiusChunks / 48;
        Pair newDeposit = gen.findNearestMapStructure(sl, (HolderSet)HolderSet.direct((Holder[])new Holder[]{target}), sp.blockPosition(), searchRadiusRegions, true);
        StructureStart structureStart = ss = newDeposit == null ? null : sl.structureManager().getStructureWithPieceAt((BlockPos)newDeposit.getFirst(), (Structure)((Holder)newDeposit.getSecond()).value());
        if (newDeposit != null && !ss.isValid()) {
            BlockPos pos = (BlockPos)newDeposit.getFirst();
            CreateRNS.LOGGER.trace("Found undiscovered deposit at {}, {}, {}", new Object[]{pos.getX(), pos.getY(), pos.getZ()});
            ((ObjectOpenHashSet)this.ungeneratedDeposits.computeIfAbsent((Object)depositKey.location(), k -> new ObjectOpenHashSet())).add((Object)pos);
            return pos;
        }
        if (newDeposit != null) {
            BlockPos pos = ss.getBoundingBox().getCenter();
            CreateRNS.LOGGER.trace("Found undiscovered generated deposit at {}, {}, {}", new Object[]{pos.getX(), pos.getY(), pos.getZ()});
            ((ObjectOpenHashSet)this.generatedDeposits.computeIfAbsent((Object)depositKey.location(), k -> new ObjectOpenHashSet())).add((Object)pos);
            return pos;
        }
        return null;
    }

    private boolean isOutsideSearchRadius(BlockPos playerPos, BlockPos dPos, int searchRadiusChunks) {
        int distZ;
        int distX = Math.abs(playerPos.getX() - dPos.getX());
        return Math.max(distX, distZ = Math.abs(playerPos.getZ() - dPos.getZ())) > searchRadiusChunks << 4;
    }

    private record CachedData(@Nullable Long dPosPacked, ResourceKey<Structure> depositKey, long creationTimestamp) {
    }
}

