/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.deposit.spec;

import com.bmaster.createrns.deposit.spec.DepositSpec;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.openmbean.KeyAlreadyExistsException;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.structure.Structure;

public class DepositSpecLookup {
    private static Map<Item, DepositSpec> scannerIconToSpec;
    private static List<Item> allIcons;
    private static Set<ResourceKey<Structure>> allStructureKeys;

    public static ResourceKey<Structure> getStructureKey(RegistryAccess access, Item scannerIconItem) {
        if (scannerIconToSpec == null) {
            DepositSpecLookup.build(access);
        }
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)scannerIconToSpec.get(scannerIconItem).structure());
    }

    public static void build(RegistryAccess access) {
        Set regEntries = access.registryOrThrow(DepositSpec.REGISTRY_KEY).entrySet();
        scannerIconToSpec = new HashMap<Item, DepositSpec>(regEntries.size());
        regEntries.forEach(e -> {
            DepositSpec spec = (DepositSpec)e.getValue();
            Item scannerIcon = spec.scannerIconItem();
            if (BuiltInRegistries.ITEM.getKeyOrNull((Object)scannerIcon) != null) {
                if (scannerIconToSpec.containsKey(scannerIcon)) {
                    throw new KeyAlreadyExistsException("Found multiple deposit specs with the same scanner icon");
                }
                scannerIconToSpec.put(scannerIcon, spec);
            }
        });
        allIcons = scannerIconToSpec.keySet().stream().sorted(Comparator.comparing(i -> {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKeyOrNull(i);
            if (rl == null) {
                throw new IllegalStateException("This never happens, but my IDE won't shut up about it");
            }
            return rl;
        })).toList();
        allStructureKeys = scannerIconToSpec.values().stream().map(hs -> ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)hs.structure())).collect(Collectors.toUnmodifiableSet());
    }

    public static List<Item> getAllScannerIcons(RegistryAccess access) {
        if (allIcons == null) {
            DepositSpecLookup.build(access);
        }
        return allIcons;
    }

    public static Predicate<Structure> isDeposit(RegistryAccess access) {
        if (allStructureKeys == null) {
            DepositSpecLookup.build(access);
        }
        Registry reg = access.registryOrThrow(Registries.STRUCTURE);
        return checkedStructure -> reg.getResourceKey(checkedStructure).filter(allStructureKeys::contains).isPresent();
    }
}

