/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.event;

import com.bmaster.createrns.RNSContent;
import com.bmaster.createrns.compat.ponder.RNSPonderPlugin;
import com.bmaster.createrns.item.DepositScanner.DepositScannerClientHandler;
import com.bmaster.createrns.mining.MiningAreaOutlineRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;

@EventBusSubscriber(modid="create_rns", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        DepositScannerClientHandler.tick();
        MiningAreaOutlineRenderer.tick();
    }

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        RNSPonderPlugin.register();
    }

    @SubscribeEvent
    public static void onScrollInput(InputEvent.MouseScrollingEvent e) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer p = mc.player;
        if (mc.player != null && mc.screen == null) {
            ItemStack mainItem = p.getMainHandItem();
            ItemStack offItem = p.getOffhandItem();
            double scrollDelta = e.getScrollDeltaY();
            if (p.level().isClientSide() && p.isShiftKeyDown() && (mainItem.is((Item)RNSContent.DEPOSIT_SCANNER_ITEM.get()) || offItem.is((Item)RNSContent.DEPOSIT_SCANNER_ITEM.get()))) {
                if (scrollDelta > 0.0) {
                    DepositScannerClientHandler.scrollUp();
                } else if (scrollDelta < 0.0) {
                    DepositScannerClientHandler.scrollDown();
                }
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut e) {
        DepositScannerClientHandler.clearState();
        MiningAreaOutlineRenderer.clearOutline();
    }
}

