/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.item.DepositScanner.DepositScannerServerHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
public record DepositScannerC2SPayload(ItemStack item, DepositScannerServerHandler.RequestType rt) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DepositScannerC2SPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"deposit_scanner_c2s"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DepositScannerC2SPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, DepositScannerC2SPayload::item, (StreamCodec)NeoForgeStreamCodecs.enumCodec(DepositScannerServerHandler.RequestType.class), DepositScannerC2SPayload::rt, DepositScannerC2SPayload::new);

    public static void handle(DepositScannerC2SPayload p, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            DepositScannerServerHandler.processScanRequest(sp, p.item.getItem(), p.rt);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

