/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.item.DepositScanner.DepositScannerClientHandler;
import com.bmaster.createrns.util.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Random;
import net.createmod.catnip.animation.AnimationFunctions;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class DepositScannerItemRenderer
extends CustomRenderedItemModelRenderer {
    private static final PartialModel UNPOWERED = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"item/deposit_scanner/unpowered"));
    private static final PartialModel POWERED = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"item/deposit_scanner/powered"));
    private static final PartialModel ANTENNA_UNPOWERED = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"item/deposit_scanner/antenna_unpowered"));
    private static final PartialModel ANTENNA_POWERED = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"item/deposit_scanner/antenna_powered"));
    public static final PartialModel WHEEL = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"item/deposit_scanner/wheel"));
    private static final int JITTER_TICKS_PER_SHAKE = 20;
    private static final float JITTER_SCALE = 0.002f;
    private static final Random rng = new Random();
    private static final LerpedFloat scrollProgress;
    private static final LerpedFloat ambientItemMovement;
    private static int poweredTicks;
    private static final LerpedFloat itemJitterX;
    private static final LerpedFloat itemJitterZ;
    private static int remainingJitterTicks;

    protected static void tick() {
        float am;
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        if (poweredTicks > 0) {
            --poweredTicks;
        }
        if (scrollProgress.settled()) {
            scrollProgress.startWithValue((double)(scrollProgress.getValue() % 360.0f));
            scrollProgress.updateChaseTarget(scrollProgress.getValue());
        }
        if (Mth.equal((float)(am = ambientItemMovement.getValue()), (float)4.0f)) {
            ambientItemMovement.setValue(0.0);
        }
        if (remainingJitterTicks > 0) {
            itemJitterX.updateChaseTarget(rng.nextFloat() - 0.5f);
            itemJitterZ.updateChaseTarget(rng.nextFloat() - 0.5f);
            --remainingJitterTicks;
        } else {
            itemJitterX.updateChaseTarget(0.0f);
            itemJitterZ.updateChaseTarget(0.0f);
        }
        scrollProgress.tickChaser();
        ambientItemMovement.tickChaser();
        itemJitterX.tickChaser();
        itemJitterZ.tickChaser();
    }

    protected static void powerBriefly() {
        poweredTicks = 2;
    }

    protected static void scrollUp() {
        scrollProgress.updateChaseTarget(scrollProgress.getChaseTarget() + 90.0f);
    }

    protected static void scrollDown() {
        scrollProgress.updateChaseTarget(scrollProgress.getChaseTarget() - 90.0f);
    }

    protected static void shakeItem() {
        remainingJitterTicks = 20;
    }

    protected static void resetWheel() {
        scrollProgress.startWithValue(0.0);
        scrollProgress.updateChaseTarget(0.0f);
    }

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buf, int light, int overlay) {
        DepositScannerItemRenderer.staticRender(stack, model, renderer, transformType, ms, buf, light, overlay);
    }

    private static void staticRender(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buf, int light, int overlay) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer p = mc.player;
        if (p == null) {
            return;
        }
        boolean rightHanded = mc.options.mainHand().get() == HumanoidArm.RIGHT;
        ItemDisplayContext mainDisplay = rightHanded ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        int handModifier = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND ? -1 : 1;
        float pt = AnimationTickHolder.getPartialTicks();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        boolean dynamic = false;
        ms.pushPose();
        if (transformType == mainDisplay && p.getOffhandItem().isEmpty()) {
            ItemTransform transform = model.getTransforms().getTransform(transformType);
            float viewAngleMultiplier = AnimationFunctions.easeIn((float)(Mth.clamp((float)p.getViewXRot(pt), (float)0.0f, (float)45.0f) / 45.0f));
            DepositScannerItemRenderer.undoModelTransform(transform, ms, msr, handModifier);
            ms.translate((double)(-0.69f * (float)handModifier), 0.1, 0.0);
            msr.rotateYDegrees(-90.0f);
            float moveOutWhenLookingDown = -0.2f * viewAngleMultiplier;
            float moveDownWhenLookingDown = -0.4f * viewAngleMultiplier;
            float rotateInWhenLookingDown = 60.0f * viewAngleMultiplier;
            ms.translate(0.4f, -0.4375f, 0.0f);
            msr.rotateZDegrees(-10.0f - rotateInWhenLookingDown);
            ms.translate(-0.4f + moveOutWhenLookingDown, 0.4375f + moveDownWhenLookingDown, 0.0f);
            dynamic = true;
        } else if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            msr.translate(-0.09375, 0.15625, 0.078125 * (double)handModifier);
            msr.rotateYDegrees((float)(12 * handModifier));
            dynamic = true;
        } else if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            msr.translate(-0.09375f, 0.1875f, 0.125f * (float)handModifier);
            msr.rotateYDegrees((float)(12 * handModifier));
            dynamic = true;
        }
        BakedModel dynamic_scanner_base = DepositScannerClientHandler.isTracking() ? POWERED.get() : UNPOWERED.get();
        renderer.render(dynamic ? dynamic_scanner_base : model.getOriginalModel(), light);
        DepositScannerItemRenderer.renderSelectedItem(ms, msr, buf, light, overlay, pt);
        if (!dynamic) {
            ms.popPose();
            return;
        }
        DepositScannerItemRenderer.renderWheel(ms, msr, renderer, light, pt);
        DepositScannerItemRenderer.renderAntennas(ms, renderer, light);
        ms.popPose();
    }

    private static void undoModelTransform(ItemTransform transform, PoseStack ms, PoseTransformStack msr, int handModifier) {
        Vector3f trn = transform.translation;
        Vector3f rot = transform.rotation;
        Vector3f scl = transform.scale;
        float sx = scl.x() == 0.0f ? 1.0f : 1.0f / scl.x();
        float sy = scl.y() == 0.0f ? 1.0f : 1.0f / scl.y();
        float sz = scl.z() == 0.0f ? 1.0f : 1.0f / scl.z();
        ms.scale(sx, sy, sz);
        msr.rotateZDegrees(-rot.z() * (float)handModifier);
        msr.rotateYDegrees(-rot.y() * (float)handModifier);
        msr.rotateXDegrees(-rot.x() * (float)handModifier);
        ms.translate(-trn.x() / 16.0f, -trn.y() / 16.0f, -trn.z() / 16.0f);
    }

    private static void renderAntennas(PoseStack ms, PartialItemModelRenderer renderer, int light) {
        PartialModel partialAntenna2;
        PartialModel partialAntenna1;
        ms.pushPose();
        if (DepositScannerClientHandler.isDepositFound() || poweredTicks > 0) {
            partialAntenna1 = switch (DepositScannerClientHandler.getAntennaStatus()) {
                default -> throw new MatchException(null, null);
                case DepositScannerClientHandler.AntennaStatus.INACTIVE, DepositScannerClientHandler.AntennaStatus.RIGHT_ACTIVE -> ANTENNA_UNPOWERED;
                case DepositScannerClientHandler.AntennaStatus.LEFT_ACTIVE, DepositScannerClientHandler.AntennaStatus.BOTH_ACTIVE -> ANTENNA_POWERED;
            };
            partialAntenna2 = switch (DepositScannerClientHandler.getAntennaStatus()) {
                default -> throw new MatchException(null, null);
                case DepositScannerClientHandler.AntennaStatus.INACTIVE, DepositScannerClientHandler.AntennaStatus.LEFT_ACTIVE -> ANTENNA_UNPOWERED;
                case DepositScannerClientHandler.AntennaStatus.RIGHT_ACTIVE, DepositScannerClientHandler.AntennaStatus.BOTH_ACTIVE -> ANTENNA_POWERED;
            };
        } else {
            partialAntenna1 = ANTENNA_UNPOWERED;
            partialAntenna2 = ANTENNA_UNPOWERED;
        }
        renderer.render(partialAntenna1.get(), light);
        ms.translate(0.0f, 0.0f, -0.5f);
        renderer.render(partialAntenna2.get(), light);
        ms.popPose();
    }

    private static void renderWheel(PoseStack ms, PoseTransformStack msr, PartialItemModelRenderer renderer, int light, float partialTicks) {
        BakedModel wheel = WHEEL.get();
        ms.pushPose();
        msr.rotateYDegrees(scrollProgress.getValue(partialTicks) % 360.0f);
        renderer.renderSolid(wheel, light);
        ms.popPose();
    }

    private static void renderSelectedItem(PoseStack ms, PoseTransformStack msr, MultiBufferSource buf, int light, int overlay, float partialTicks) {
        float am = ambientItemMovement.getValue(partialTicks);
        int phase = am < 2.0f ? 1 : -1;
        float amLiftEased = (Utils.easeInOut(am % 2.0f / 2.0f, 2.0f) - 0.5f) * 2.0f * (float)phase;
        float amRotEased = Utils.easeInOut(1.0f - Math.abs(am % 2.0f / 2.0f - 0.5f) * 2.0f, 1.2f) * (float)phase;
        float jitterX = itemJitterX.getValue(partialTicks) * 0.002f * (float)remainingJitterTicks / 20.0f;
        float jitterZ = itemJitterZ.getValue(partialTicks) * 0.002f * (float)remainingJitterTicks / 20.0f;
        float cx = 0.0f;
        float cy = -0.25f;
        float cz = 0.0f;
        ms.pushPose();
        ms.translate(cx + jitterX, cy + amLiftEased / 96.0f, cz + jitterZ);
        ms.scale(0.15f, 0.15f, 0.15f);
        msr.rotateXDegrees(-90.0f);
        msr.rotateZDegrees(90.0f);
        msr.rotateXDegrees(10.0f * amRotEased);
        Minecraft.getInstance().getItemRenderer().renderStatic(DepositScannerClientHandler.getSelectedItem(), ItemDisplayContext.GUI, light, overlay, ms, buf, null, 0);
        ms.popPose();
    }

    static {
        poweredTicks = 0;
        remainingJitterTicks = 0;
        scrollProgress = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.5, LerpedFloat.Chaser.EXP);
        ambientItemMovement = LerpedFloat.linear().startWithValue(2.0).chase(4.0, (double)0.04f, LerpedFloat.Chaser.LINEAR);
        itemJitterX = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 2.0, LerpedFloat.Chaser.EXP);
        itemJitterZ = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 2.0, LerpedFloat.Chaser.EXP);
    }
}

