/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.item.DepositScanner;

import com.bmaster.createrns.item.DepositScanner.DepositScannerClientHandler;
import com.bmaster.createrns.item.DepositScanner.DepositScannerServerHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@MethodsReturnNonnullByDefault
public record DepositScannerS2CPayload(DepositScannerClientHandler.AntennaStatus antennaStatus, int interval, boolean found, DepositScannerServerHandler.RequestType rt) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DepositScannerS2CPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"create_rns", (String)"deposit_scanner_s2c"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DepositScannerS2CPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(DepositScannerClientHandler.AntennaStatus.class), DepositScannerS2CPayload::antennaStatus, (StreamCodec)ByteBufCodecs.INT, DepositScannerS2CPayload::interval, (StreamCodec)ByteBufCodecs.BOOL, DepositScannerS2CPayload::found, (StreamCodec)NeoForgeStreamCodecs.enumCodec(DepositScannerServerHandler.RequestType.class), DepositScannerS2CPayload::rt, DepositScannerS2CPayload::new);

    public static void handle(DepositScannerS2CPayload p, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null || !mc.player.level().isClientSide()) {
                return;
            }
            switch (p.rt) {
                case DISCOVER: {
                    DepositScannerClientHandler.processDiscoverReply(p.antennaStatus);
                    break;
                }
                case TRACK: {
                    DepositScannerClientHandler.processTrackingReply(p.antennaStatus, p.interval, p.found);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

