/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining.miner;

import com.bmaster.createrns.mining.MiningBlock;
import com.bmaster.createrns.mining.MiningEntityItemHandler;
import com.bmaster.createrns.mining.miner.MinerBlockEntity;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MinerBlock<BE extends MinerBlockEntity>
extends MiningBlock
implements IBE<BE>,
ICogWheel {
    public static Direction.Axis getRotationAxis() {
        return Direction.Axis.Y;
    }

    public MinerBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public abstract Class<BE> getBlockEntityClass();

    public abstract BlockEntityType<? extends BE> getBlockEntityType();

    @ParametersAreNonnullByDefault
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level l, BlockPos pos, Player p, BlockHitResult hitResult) {
        return this.onBlockEntityUse((BlockGetter)l, pos, be -> {
            MiningEntityItemHandler minerInv = Objects.requireNonNull(be.getItemHandler(null));
            if (minerInv.isEmpty()) {
                return InteractionResult.PASS;
            }
            Inventory playerInv = p.getInventory();
            boolean pickedUp = false;
            for (int i = 0; i < minerInv.getSlots(); ++i) {
                ItemStack stack = minerInv.extractItem(i, false);
                if (stack.isEmpty()) continue;
                playerInv.placeItemBackInInventory(stack);
                pickedUp = true;
            }
            if (pickedUp) {
                l.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + l.random.nextFloat());
            }
            return InteractionResult.SUCCESS;
        });
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.CASING_12PX.get(Direction.DOWN);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return MinerBlock.getRotationAxis();
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.FAST;
    }
}

