/*
 * Decompiled with CFR 0.152.
 */
package com.bmaster.createrns.mining.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class MiningRecipe
implements Recipe<SingleRecipeInput> {
    private final Block depositBlock;
    private final Item yield;

    public MiningRecipe(Block depositBlock, Item yield) {
        this.depositBlock = depositBlock;
        this.yield = yield;
    }

    public Block getDepositBlock() {
        return this.depositBlock;
    }

    public Item getYield() {
        return this.yield;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)this.yield);
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{this.depositBlock})});
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(SingleRecipeInput singleRecipeInput, Level level) {
        return singleRecipeInput.item().is(this.getDepositBlock().asItem());
    }

    public ItemStack assemble(SingleRecipeInput singleRecipeInput, HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)this.getYield());
    }

    public static abstract class Serializer<R extends MiningRecipe>
    implements RecipeSerializer<R> {
        public final MapCodec<R> CODEC;
        public final StreamCodec<RegistryFriendlyByteBuf, R> STREAM_CODEC;
        private final BiFunction<Block, Item, R> recipeFactory;

        public Serializer(BiFunction<Block, Item, R> recipeFactory) {
            this.recipeFactory = recipeFactory;
            this.CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("deposit_block").forGetter(MiningRecipe::getDepositBlock), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("yield").forGetter(MiningRecipe::getYield)).apply((Applicative)i, recipeFactory));
            this.STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);
        }

        public void toNetwork(RegistryFriendlyByteBuf buffer, R recipe) {
            ByteBufCodecs.registry((ResourceKey)Registries.BLOCK).encode((Object)buffer, (Object)((MiningRecipe)recipe).getDepositBlock());
            ByteBufCodecs.registry((ResourceKey)Registries.ITEM).encode((Object)buffer, (Object)((MiningRecipe)recipe).getYield());
        }

        public R fromNetwork(RegistryFriendlyByteBuf buffer) {
            return (R)((MiningRecipe)this.recipeFactory.apply((Block)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK).decode((Object)buffer), (Item)ByteBufCodecs.registry((ResourceKey)Registries.ITEM).decode((Object)buffer)));
        }

        public MapCodec<R> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.STREAM_CODEC;
        }
    }
}

