package com.provismet.tooltipscroll.config;

import com.provismet.tooltipscroll.Options;
import com.provismet.tooltipscroll.ScrollTracker;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class TooltipConfig {
    public static class_437 build (class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create();
        builder.setParentScreen(parent);
        builder.setTitle(class_2561.method_43471("title.tooltipscroll.config"));
        
        ConfigCategory general = builder.getOrCreateCategory(class_2561.method_43471("category.tooltipscroll.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();

        general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.tooltipscroll.canscroll"), Options.canScroll)
            .setDefaultValue(true)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.canscroll"))
            .setSaveConsumer(newValue -> Options.canScroll = newValue)
            .build());

        general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.tooltipscroll.usewasd"), Options.useWASD)
            .setDefaultValue(false)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.usewasd"))
            .setSaveConsumer(newValue -> Options.useWASD = newValue)
            .build());

        general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.tooltipscroll.startontop"), Options.startOnTop)
            .setDefaultValue(false)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.startontop"))
            .setSaveConsumer(newValue -> Options.startOnTop = newValue)
            .build());
        
        general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.tooltipscroll.resetonunlock"), Options.resetOnUnlock)
            .setDefaultValue(true)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.resetonunlock"))
            .setSaveConsumer(newValue -> Options.resetOnUnlock = newValue)
            .build());

        general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.tooltipscroll.uselshift"), Options.useLShift)
            .setDefaultValue(true)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.uselshift"))
            .setSaveConsumer(newValue -> Options.useLShift = newValue)
            .build());

        general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.tooltipscroll.invertxscroll"), Options.invertXScroll)
                .setDefaultValue(false)
                .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.invertxscroll"))
                .setSaveConsumer(newValue -> Options.invertXScroll = newValue)
                .build());

        general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("entry.tooltipscroll.invertyscroll"), Options.invertYScroll)
                .setDefaultValue(false)
                .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.invertyscroll"))
                .setSaveConsumer(newValue -> Options.invertYScroll = newValue)
                .build());

        general.addEntry(entryBuilder.startIntField(class_2561.method_43471("entry.tooltipscroll.scrollspeed"), ScrollTracker.scrollSize)
            .setDefaultValue(10)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.scrollspeed"))
            .setSaveConsumer(newValue -> ScrollTracker.scrollSize = (int)class_3532.method_15391(1, newValue))
            .build());
        
        general.addEntry(entryBuilder.startIntField(class_2561.method_43471("entry.tooltipscroll.scrollspeedkeys"), ScrollTracker.scrollSizeKeyboard)
            .setDefaultValue(5)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.scrollspeedkeys"))
            .setSaveConsumer(newValue -> ScrollTracker.scrollSizeKeyboard = (int)class_3532.method_15391(1, newValue))
            .build());

        general.addEntry(entryBuilder.startDoubleField(class_2561.method_43471("entry.tooltipscroll.smoothness"), ScrollTracker.smoothnessModifier)
            .setDefaultValue(0.25)
            .setTooltip(class_2561.method_43471("entrytooltip.tooltipscroll.smoothness"))
            .setSaveConsumer(newValue -> {
                ScrollTracker.smoothnessModifier = class_3532.method_15391(0.05, newValue);
                if (ScrollTracker.smoothnessModifier > 1.0) ScrollTracker.smoothnessModifier = 1.0;
            })
            .build());

        builder.setSavingRunnable(Options::saveJSON);
        return builder.build();
    }
}
