package com.provismet.tooltipscroll.mixin;

import com.provismet.tooltipscroll.Options;
import com.provismet.tooltipscroll.ScrollTracker;
import com.provismet.tooltipscroll.TooltipScrollClient;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_312.class)
public class MouseMixin {
    // This will affect *every* use of the mouse wheel and alter the tracker accordingly.
    // Has no impact from a blackbox perspective though since the tooltip position will be reset when selecting an item.
    @Inject(method = "onMouseScroll(JDD)V", at = @At("HEAD"))
    private void trackWheel (long window, double horizontal, double vertical, CallbackInfo info) {
        if (!Options.canScroll) return;

        long mcHandle = class_310.method_1551().method_22683().method_4490();
        int horizontalMove = ((KeyBindAccessor)TooltipScrollClient.horizontal).getBoundKey().method_1444();

        if ((horizontalMove != -1 && class_3675.method_15987(mcHandle, horizontalMove)) || (Options.useLShift && class_3675.method_15987(mcHandle, GLFW.GLFW_KEY_LEFT_SHIFT))) {
            scrollX(vertical);
        }
        else {
            scrollY(vertical);
        }

        // Implementation for side scroll-wheels
        if (horizontal > 0) ScrollTracker.scrollLeft();
        else if (horizontal < 0) ScrollTracker.scrollRight();
    }

    @Unique
    private void scrollX(double vertical) {
        if (Options.invertXScroll) {
            if (vertical > 0) ScrollTracker.scrollRight();
            else if (vertical < 0) ScrollTracker.scrollLeft();
        }
        else {
            if (vertical > 0) ScrollTracker.scrollLeft();
            else if (vertical < 0) ScrollTracker.scrollRight();
        }
    }

    @Unique
    private void scrollY(double vertical) {
        if (Options.invertYScroll) {
            if (vertical > 0) ScrollTracker.scrollDown();
            else if (vertical < 0) ScrollTracker.scrollUp();
        }
        else {
            if (vertical > 0) ScrollTracker.scrollUp();
            else if (vertical < 0) ScrollTracker.scrollDown();
        }
    }
}
